/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.tree;

import gda.data.nexus.tree.INexusTree;

class Group {
    final String name;
    final String NXclass;

    public static Group getInstance(Group source) {
        return new Group(source.name, source.NXclass);
    }

    public Group(String name, String NXclass) {
        this.name = name;
        this.NXclass = NXclass;
    }

    public Group(INexusTree node) {
        this.name = node.getName();
        this.NXclass = node.getNxClass();
    }

    public boolean containsSDS() {
        return this.getNXclass().equals("SDS");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.NXclass == null ? 0 : this.NXclass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        return this.name.equals(other.name) && this.NXclass.equals(other.NXclass);
    }

    public String getName() {
        return this.name;
    }

    public String getNXclass() {
        return this.NXclass;
    }

    public String toString() {
        return String.valueOf(this.name) + "." + this.NXclass;
    }
}

