/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.nxclassio;

import gda.data.nexus.nxclassio.NexusGroup;
import java.util.Vector;

public class NexusPath {
    private Vector<NexusGroup> groups = new Vector();
    private String dataSetName;

    public String getDataSetName() {
        return this.dataSetName == null ? "" : this.dataSetName;
    }

    public Vector<NexusGroup> getGroups() {
        return this.groups;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public void addGroupPath(NexusGroup group) {
        this.groups.add(group);
    }

    public boolean isOfClass(String className) {
        return this.getGroups().lastElement().getNXclass().equals(className);
    }

    public String getNXClassName() {
        return this.getGroups().lastElement().getNXclass();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataSetName == null ? 0 : this.dataSetName.hashCode());
        result = 31 * result + (this.groups == null ? 0 : this.groups.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NexusPath)) {
            return false;
        }
        NexusPath other = (NexusPath)o;
        return this.groups.equals(other.groups) && this.dataSetName.equals(other.dataSetName);
    }

    public static NexusPath getInstance(NexusPath source) {
        NexusPath copy = new NexusPath();
        Vector<NexusGroup> groups = source.getGroups();
        for (NexusGroup group : groups) {
            copy.addGroupPath(NexusGroup.getInstance(group));
        }
        copy.setDataSetName(new String(source.getDataSetName()));
        return copy;
    }
}

