/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.nxclassio;

import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.nxclassio.NexusGroup;
import gda.data.nexus.nxclassio.NexusPath;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;

public class NexusFileHandle {
    Boolean create = false;
    NexusPath currentNexusPath = null;
    private NexusFile file = null;
    final String fileName;
    final Boolean writeable;

    public static int calcTotalLength(int[] dimensions) {
        int totalLength = 1;
        int i = 0;
        while (i < dimensions.length) {
            totalLength *= dimensions[i];
            ++i;
        }
        return totalLength;
    }

    public NexusFileHandle(String fileName, boolean writeable) {
        this.fileName = fileName;
        this.writeable = writeable;
        this.create = writeable;
    }

    synchronized void close() throws NexusException {
        if (this.file != null) {
            this.file.close();
            this.file = null;
        }
        this.currentNexusPath = null;
    }

    private synchronized void closeData() throws NexusException {
        if (this.file != null) {
            if (this.currentNexusPath != null) {
                if (!this.currentNexusPath.getDataSetName().isEmpty()) {
                    this.file.closedata();
                }
                try {
                    Iterator<NexusGroup> iterator = this.currentNexusPath.getGroups().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                        this.file.closegroup();
                    }
                }
                catch (NexusException ex) {
                    this.close();
                    throw ex;
                }
            }
            this.currentNexusPath = null;
        }
    }

    synchronized void getdata(NexusPath nexusPath, double[] buffer) throws NexusException, NexusExtractorException {
        this.openData(nexusPath, false);
        this.file.getdata((Object)buffer);
    }

    synchronized void getinfo(NexusPath nexusPath, int[] iDim, int[] iStart) throws NexusException, NexusExtractorException {
        this.openData(nexusPath, false);
        this.file.getinfo(iDim, iStart);
    }

    synchronized String getNameForClass(NexusPath nexusPath, String className) throws NexusExtractorException {
        try {
            this.openData(nexusPath, false);
            Hashtable dir = this.file.groupdir();
            Set set = dir.entrySet();
            for (Map.Entry entry : set) {
                if (!((String)entry.getValue()).equals(className)) continue;
                return (String)entry.getKey();
            }
        }
        catch (Exception ex) {
            throw new NexusExtractorException("Unable to find item of class " + className + " at " + nexusPath.toString(), ex);
        }
        throw new NexusExtractorException("Unable to find item of class " + className + " at " + nexusPath.toString());
    }

    synchronized String getString(NexusPath nexusPath) throws NexusException, NexusExtractorException {
        this.openData(nexusPath, false);
        int[] iDim = new int[20];
        int[] iStart = new int[2];
        this.file.getinfo(iDim, iStart);
        int dimension = iDim[0];
        byte[] bytes = new byte[dimension];
        this.file.getdata((Object)bytes);
        return new String(bytes);
    }

    synchronized void openData(NexusPath nexusPath, boolean create) throws NexusException, NexusExtractorException {
        this.openfile();
        if (this.currentNexusPath == null) {
            try {
                for (NexusGroup group : nexusPath.getGroups()) {
                    if (create) {
                        Hashtable dir = this.file.groupdir();
                        String className = (String)dir.get(group.getName());
                        if (className == null) {
                            this.file.makegroup(group.getName(), group.getNXclass());
                        } else if (!className.equals(group.getNXclass())) {
                            throw new NexusExtractorException("Unable to open " + nexusPath + " as other class of element with same name exists");
                        }
                    }
                    this.file.opengroup(group.getName(), group.getNXclass());
                }
            }
            catch (NexusException ex) {
                this.close();
                throw ex;
            }
            if (!nexusPath.getDataSetName().isEmpty()) {
                this.file.opendata(nexusPath.getDataSetName());
            }
            this.currentNexusPath = NexusPath.getInstance(nexusPath);
        } else if (!this.currentNexusPath.equals(nexusPath)) {
            this.closeData();
            try {
                for (NexusGroup group : nexusPath.getGroups()) {
                    if (create) {
                        Hashtable dir = this.file.groupdir();
                        String className = (String)dir.get(group.getName());
                        if (className == null) {
                            this.file.makegroup(group.getName(), group.getNXclass());
                        } else if (!className.equals(group.getNXclass())) {
                            throw new NexusExtractorException("Unable to open " + nexusPath + " as other class of element with same name exists");
                        }
                    }
                    this.file.opengroup(group.getName(), group.getNXclass());
                }
            }
            catch (NexusException ex) {
                this.close();
                throw ex;
            }
            if (!nexusPath.getDataSetName().isEmpty()) {
                this.file.opendata(nexusPath.getDataSetName());
            }
            this.currentNexusPath = NexusPath.getInstance(nexusPath);
        }
    }

    private synchronized void openfile() throws NexusException {
        if (this.file == null) {
            this.file = new NexusFile(this.fileName, this.writeable.booleanValue() ? (this.create.booleanValue() ? 5 : 2) : 1);
            this.create = false;
            this.currentNexusPath = null;
        }
    }

    private synchronized void setData(NexusPath nexusPath, String dataName, int type, int[] dims, Object data) throws NexusException, NexusExtractorException {
        NexusPath path = NexusPath.getInstance(nexusPath);
        path.setDataSetName(null);
        this.openData(path, true);
        this.file.makedata(dataName, type, dims.length, dims);
        path.setDataSetName(dataName);
        this.openData(path, false);
        this.file.putdata(data);
    }

    synchronized void setDoubleData(NexusPath nexusPath, String dataName, int[] dims, double[] data) throws NexusException, NexusExtractorException {
        this.setData(nexusPath, dataName, 6, dims, data);
    }

    synchronized void setString(NexusPath nexusPath, String dataName, String value) throws NexusException, NexusExtractorException {
        byte[] buf = value.getBytes();
        int[] dims = new int[]{buf.length};
        this.setData(nexusPath, dataName, 4, dims, buf);
    }
}

