/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.nxclassio;

import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.nxclassio.NexusFileHandle;
import gda.data.nexus.nxclassio.NexusGroup;
import gda.data.nexus.nxclassio.NexusPath;
import org.nexusformat.NexusException;

class NXSource {
    public static String NXClassName = "NXsource";
    final String name;
    final boolean top_up;

    static NXSource getFromNexus(NexusFileHandle nfh, NexusPath nexusPath) throws NexusException, NexusExtractorException {
        NexusPath myPath = NexusPath.getInstance(nexusPath);
        myPath.setDataSetName("");
        String name = nfh.getNameForClass(nexusPath, NXClassName);
        myPath.addGroupPath(new NexusGroup(name, NXClassName));
        myPath.setDataSetName("name");
        name = nfh.getString(myPath);
        return new NXSource(name, false);
    }

    void addToNexus(NexusFileHandle nfh, NexusPath nexusPath) throws NexusException, NexusExtractorException {
        NexusPath myPath = NexusPath.getInstance(nexusPath);
        myPath.addGroupPath(new NexusGroup(this.name, NXClassName));
        myPath.setDataSetName("");
        nfh.openData(myPath, true);
    }

    NXSource(String name, boolean top_up) {
        this.name = name;
        this.top_up = top_up;
    }

    public String toString() {
        return "NXsource : '" + this.name + "'\n" + (this.top_up ? "top_up is ON" : "top_up is OFF ");
    }
}

