/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.nxclassio;

import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.nxclassio.NXAperture;
import gda.data.nexus.nxclassio.NXSource;
import gda.data.nexus.nxclassio.NexusFileHandle;
import gda.data.nexus.nxclassio.NexusGroup;
import gda.data.nexus.nxclassio.NexusPath;
import org.nexusformat.NexusException;

public class NXInstrument {
    final String name;
    final NXSource source;
    final NXAperture aperture;
    public static String NXClassName = "NXinstrument";

    static NXInstrument getFromNexus(NexusFileHandle nfh, NexusPath nexusPath) throws NexusException, NexusExtractorException {
        NexusPath myPath = NexusPath.getInstance(nexusPath);
        myPath.setDataSetName("");
        String name = nfh.getNameForClass(myPath, NXClassName);
        myPath.addGroupPath(new NexusGroup(name, NXClassName));
        myPath.setDataSetName("name");
        name = nfh.getString(myPath);
        NXSource source = NXSource.getFromNexus(nfh, myPath);
        return new NXInstrument(name, source, null);
    }

    void addToNexus(NexusFileHandle nfh, NexusPath nexusPath) throws NexusException, NexusExtractorException {
        NexusPath myPath = NexusPath.getInstance(nexusPath);
        myPath.addGroupPath(new NexusGroup(this.name, NXClassName));
        myPath.setDataSetName("");
        nfh.openData(myPath, true);
        this.source.addToNexus(nfh, myPath);
        this.aperture.addToNexus(nfh, myPath);
    }

    public String getNXClassName() {
        return NXClassName;
    }

    NXInstrument(String name, NXSource source, NXAperture aperture) {
        this.name = name;
        this.source = source;
        this.aperture = aperture;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "NXinstrument : '" + this.name + "'\n" + this.source.toString() + "\n" + (this.aperture == null ? "no aperture " : this.aperture.toString());
    }
}

