/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.extractor;

import gda.data.nexus.NexusFileWrapper;
import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.nexusformat.AttributeEntry;
import org.nexusformat.NeXusFileInterface;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;

class SimpleExtractor {
    URL source;
    String nodePathWithClasses;
    boolean debug;
    int[] startPos;
    int[] dims;

    SimpleExtractor(URL source, String nodePathWithClasses, int[] startPos, int[] dims, boolean debug) {
        this.debug = debug;
        this.source = source;
        this.startPos = startPos;
        this.dims = dims;
        this.nodePathWithClasses = nodePathWithClasses;
    }

    public NexusGroupData getData(NeXusFileInterface file, String nodePathWithClasses) throws NexusException, NexusExtractorException {
        String[] nodeIds = nodePathWithClasses.split("/", 3);
        if (!(nodeIds[0].equals("") && nodeIds[1].equals("") || nodeIds[1].equals("SDS") || nodeIds[1].equals("Attr"))) {
            file.opengroup(nodeIds[0], nodeIds[1]);
        }
        if (nodeIds.length > 2 && !nodeIds[2].isEmpty()) {
            if (nodeIds[1].equals("SDS")) {
                file.opendata(nodeIds[0]);
            }
            return this.getData(file, nodeIds[2]);
        }
        boolean isAttr = nodeIds[1].equals("Attr");
        String attrName = nodeIds[0];
        int attrType = 0;
        int attrLength = 0;
        if (isAttr) {
            Hashtable dir = file.attrdir();
            Set set = dir.entrySet();
            for (Map.Entry entry : set) {
                if (!((String)entry.getKey()).equals(attrName)) continue;
                AttributeEntry attrEntry = (AttributeEntry)entry.getValue();
                attrType = attrEntry.type;
                attrLength = attrEntry.length;
                break;
            }
        }
        return NexusExtractor.getNexusGroupData(file, nodeIds[0], attrName, true, isAttr, attrType, attrLength, this.startPos, this.dims);
    }

    protected final NexusGroupData getData() throws NexusException, NexusExtractorException {
        Object file = new NexusFile(this.source.getPath(), 1);
        if (this.debug) {
            file = new NexusFileWrapper((NeXusFileInterface)file);
        }
        try {
            NexusGroupData nexusGroupData = this.getData((NeXusFileInterface)file, this.nodePathWithClasses);
            return nexusGroupData;
        }
        finally {
            file.close();
        }
    }
}

