/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.extractor;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusGroupData
implements Serializable {
    private static final transient Logger logger = LoggerFactory.getLogger(NexusGroupData.class);
    private Serializable data;
    public int[] dimensions;
    public final int type;
    public boolean isDetectorEntryData = false;

    public NexusGroupData(int[] dimensions, int type, Serializable data) {
        this.dimensions = dimensions;
        this.type = type;
        this.data = data;
    }

    public NexusGroupData(String s) {
        try {
            this.data = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.data = s.getBytes();
        }
        this.dimensions = new int[1];
        this.dimensions[0] = s.length();
        this.type = 4;
    }

    public NexusGroupData(Integer i) {
        int[] idata = new int[]{i};
        this.dimensions = new int[]{idata.length};
        this.data = idata;
        this.type = 24;
    }

    public Serializable getBuffer() {
        return this.data;
    }

    public Object releaseData() {
        Serializable d = this.data;
        this.data = null;
        return d;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer("");
        msg.append("<dimensions>");
        int[] nArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            msg.append("<dimension>" + i + "</dimension>");
            ++n2;
        }
        msg.append("</dimensions>");
        msg.append("<type>");
        switch (this.type) {
            case 4: {
                msg.append("NX_CHAR");
                break;
            }
            case 6: {
                msg.append("NX_FLOAT64");
                break;
            }
            default: {
                msg.append(this.type);
            }
        }
        msg.append("</type>");
        return msg.toString();
    }

    public String dataToTxt(boolean newlineAfterEach, boolean dataAsString, boolean wrap) {
        StringBuffer msg = new StringBuffer();
        if (this.data != null) {
            if (this.type == 4 && this.data instanceof byte[]) {
                if (wrap) {
                    msg.append("<value>");
                }
                msg.append(new String((byte[])this.data));
                if (wrap) {
                    msg.append("</value>");
                }
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            } else if (dataAsString) {
                if (wrap) {
                    msg.append("<value>");
                }
                if (this.data instanceof double[]) {
                    double[] ddata;
                    double[] dArray = ddata = (double[])this.data;
                    int n = ddata.length;
                    int n2 = 0;
                    while (n2 < n) {
                        double d = dArray[n2];
                        msg.append(String.valueOf(Double.toString(d)) + ",");
                        ++n2;
                    }
                    msg.deleteCharAt(msg.length() - 1);
                } else if (this.data instanceof int[]) {
                    int[] ddata;
                    int[] nArray = ddata = (int[])this.data;
                    int n = ddata.length;
                    int n3 = 0;
                    while (n3 < n) {
                        int d = nArray[n3];
                        msg.append(String.valueOf(Integer.toString(d)) + ",");
                        ++n3;
                    }
                    msg.deleteCharAt(msg.length() - 1);
                } else if (this.data instanceof byte[]) {
                    byte[] ddata;
                    byte[] byArray = ddata = (byte[])this.data;
                    int n = ddata.length;
                    int n4 = 0;
                    while (n4 < n) {
                        byte d = byArray[n4];
                        msg.append(String.valueOf(Byte.toString(d)) + ",");
                        ++n4;
                    }
                    msg.deleteCharAt(msg.length() - 1);
                } else if (this.data instanceof float[]) {
                    float[] ddata;
                    float[] fArray = ddata = (float[])this.data;
                    int n = ddata.length;
                    int n5 = 0;
                    while (n5 < n) {
                        float d = fArray[n5];
                        msg.append(String.valueOf(Float.toString(d)) + ",");
                        ++n5;
                    }
                    msg.deleteCharAt(msg.length() - 1);
                } else if (this.data instanceof long[]) {
                    long[] ddata;
                    long[] lArray = ddata = (long[])this.data;
                    int n = ddata.length;
                    int n6 = 0;
                    while (n6 < n) {
                        long d = lArray[n6];
                        msg.append(String.valueOf(Long.toString(d)) + ",");
                        ++n6;
                    }
                    msg.deleteCharAt(msg.length() - 1);
                } else {
                    msg.append(this.data.toString());
                }
                if (wrap) {
                    msg.append("</value>");
                }
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            } else {
                msg.append("<values>");
                if (newlineAfterEach) {
                    msg.append("\n");
                }
                if (this.data instanceof double[]) {
                    double[] ddata;
                    double[] dArray = ddata = (double[])this.data;
                    int n = ddata.length;
                    int n7 = 0;
                    while (n7 < n) {
                        double d = dArray[n7];
                        msg.append("<value>");
                        msg.append(Double.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n7;
                    }
                } else if (this.data instanceof int[]) {
                    int[] ddata;
                    int[] nArray = ddata = (int[])this.data;
                    int n = ddata.length;
                    int n8 = 0;
                    while (n8 < n) {
                        int d = nArray[n8];
                        msg.append("<value>");
                        msg.append(Integer.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n8;
                    }
                } else if (this.data instanceof byte[]) {
                    byte[] ddata;
                    byte[] byArray = ddata = (byte[])this.data;
                    int n = ddata.length;
                    int n9 = 0;
                    while (n9 < n) {
                        byte d = byArray[n9];
                        msg.append("<value>");
                        msg.append(Byte.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n9;
                    }
                } else if (this.data instanceof float[]) {
                    float[] ddata;
                    float[] fArray = ddata = (float[])this.data;
                    int n = ddata.length;
                    int n10 = 0;
                    while (n10 < n) {
                        float d = fArray[n10];
                        msg.append("<value>");
                        msg.append(Float.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n10;
                    }
                } else if (this.data instanceof long[]) {
                    long[] ddata;
                    long[] lArray = ddata = (long[])this.data;
                    int n = ddata.length;
                    int n11 = 0;
                    while (n11 < n) {
                        long d = lArray[n11];
                        msg.append("<value>");
                        msg.append(Long.toString(d));
                        msg.append("</value>");
                        if (newlineAfterEach) {
                            msg.append("\n");
                        }
                        ++n11;
                    }
                } else {
                    msg.append(this.data.toString());
                }
                msg.append("</values>");
                if (newlineAfterEach) {
                    msg.append("\n");
                }
            }
        }
        return msg.toString();
    }

    public Serializable getFirstValue() {
        Object value;
        if (this.dimensions == null || this.data == null) {
            return null;
        }
        if (this.dimensions.length < 1) {
            return null;
        }
        if (this.dimensions[0] < 1) {
            return null;
        }
        switch (this.type) {
            case 4: {
                if (this.data instanceof String) {
                    value = this.data;
                    break;
                }
                value = new String((byte[])this.data);
                break;
            }
            case 6: {
                value = ((double[])this.data)[0];
                break;
            }
            case 5: {
                value = (double)((float[])this.data)[0];
                break;
            }
            case 26: {
                value = ((long[])this.data)[0];
                break;
            }
            case 24: {
                value = ((int[])this.data)[0];
                break;
            }
            case 22: {
                value = (int)((short[])this.data)[0];
                break;
            }
            case 20: {
                value = (int)((byte[])this.data)[0];
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false);
    }

    public boolean equals(Object obj, boolean reportFalse) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NexusGroupData other = (NexusGroupData)obj;
        if (this.data == null) {
            if (other.data != null) {
                return false;
            }
        } else if (!this.dataToTxt(false, false, false).equals(other.dataToTxt(false, false, false))) {
            if (reportFalse) {
                logger.info("expected = " + this.dataToTxt(false, true, false) + ", actual= " + other.dataToTxt(false, true, false));
            }
            return false;
        }
        return true;
    }
}

