/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.extractor;

import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusSourceProvider;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeBuilder;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import gda.util.TestUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nexusformat.NexusException;

public class NexusExtractorTest {
    String scratchFolder;
    URL testdataFile;
    static String TestFileFolder;

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.scratchFolder = TestUtils.setUpTest(NexusExtractorTest.class, (String)"setUp", (boolean)true);
    }

    @After
    public void tearDown() {
    }

    @Test
    public void testGetNexusGroupDataURLStringBoolean() throws NexusException, NexusExtractorException {
        INexusTree tree = NexusTreeBuilder.getNexusTree(String.valueOf(TestFileFolder) + "327.nxs", NexusTreeNodeSelection.createTreeForAllNXData());
        INexusTree node = tree.getChildNode(0).getChildNode(22).getChildNode(0);
        NexusGroupData data = NexusExtractor.getNexusGroupData(((INexusSourceProvider)((Object)tree)).getSource(), node.getNodePathWithClasses(), null, null, true);
        Assert.assertEquals((Object)node.getData(), (Object)data);
        node = tree.getChildNode(0).getChildNode(22).getChildNode(0).getChildNode(1);
        data = NexusExtractor.getNexusGroupData(((INexusSourceProvider)((Object)tree)).getSource(), node.getNodePathWithClasses(), null, null, true);
        Assert.assertEquals((Object)node.getData(), (Object)data);
        node = tree.getChildNode(0).getChildNode(22).getChildNode(0);
        int[] dims = node.getData().dimensions;
        int[] startPos = new int[dims.length];
        dims[dims.length - 1] = 1;
        startPos[startPos.length - 1] = 1;
        data = NexusExtractor.getNexusGroupData(((INexusSourceProvider)((Object)tree)).getSource(), node.getNodePathWithClasses(), startPos, dims, true);
        Assert.assertEquals((long)1L, (long)data.dimensions[dims.length - 1]);
    }

    @Test
    public void testGetNexusGroupDataURLStringBoolean2() throws NexusException, NexusExtractorException, MalformedURLException {
        String pathWithClass = "//entry1/NXentry/EDXD_Element_22/NXdata/a/SDS/";
        URL url = new URL("file:" + new File(String.valueOf(TestFileFolder) + "327.nxs").getAbsolutePath());
        NexusGroupData data = NexusExtractor.getNexusGroupData(url, pathWithClass, null, null, true);
        Assert.assertEquals((long)6L, (long)data.type);
        Assert.assertEquals((long)1L, (long)data.dimensions.length);
        Assert.assertEquals((long)11L, (long)data.dimensions[0]);
        Assert.assertEquals((Object)1.0, (Object)((double[])data.getBuffer())[10]);
        int[] dims = new int[]{2};
        int[] startPos = new int[]{2};
        data = NexusExtractor.getNexusGroupData(url, pathWithClass, dims, startPos, true);
        Assert.assertEquals((long)6L, (long)data.type);
        Assert.assertEquals((long)1L, (long)data.dimensions.length);
        Assert.assertEquals((long)2L, (long)data.dimensions[0]);
        Assert.assertEquals((Object)0.2, (Object)((double[])data.getBuffer())[0]);
        Assert.assertEquals((Object)0.3, (Object)((double[])data.getBuffer())[1]);
    }
}

