/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus.extractor;

import gda.data.nexus.NexusFileWrapper;
import gda.data.nexus.extractor.Attr;
import gda.data.nexus.extractor.Group;
import gda.data.nexus.extractor.INexusDataGetter;
import gda.data.nexus.extractor.INexusTreeProcessor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.extractor.SimpleExtractor;
import gda.data.nexus.tree.INexusSourceProvider;
import gda.data.nexus.tree.INexusTree;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.nexusformat.AttributeEntry;
import org.nexusformat.NeXusFileInterface;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.gda.monitor.IMonitor;

public final class NexusExtractor
implements INexusDataGetter {
    private static final Logger logger = LoggerFactory.getLogger(NexusExtractor.class);
    public static final String NXDataClassName = "NXdata";
    public static final String NXEntryClassName = "NXentry";
    public static final String NXInstrumentClassName = "NXinstrument";
    public static final String NXPositionerClassName = "NXpositioner";
    public static final String NXNoteClassName = "NXnote";
    public static final String NXDetectorClassName = "NXdetector";
    public static final String SDSClassName = "SDS";
    public static final String AttrClassName = "Attr";
    public static final String ExternalSDSLink = "ExternalSDSLink";
    public static final int DATAWANTED_NX_CHAR = 1;
    public static final int DATAWANTED_NX_FLOAT64 = 2;
    public static final String topClass = "";
    public static final String topName = "";
    private Group currentGroupBeingProcessed = null;
    private NeXusFileInterface file = null;
    final String fileName;
    private INexusTreeProcessor loopProcessor;

    public static int calcTotalLength(int[] dimensions) {
        int totalLength = 1;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int dimension = nArray[n2];
            totalLength *= dimension;
            ++n2;
        }
        return totalLength;
    }

    public static long calcTotalLengthLong(int[] dimensions) {
        long totalLength = 1L;
        int[] nArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int dimension = nArray[n2];
            totalLength *= (long)dimension;
            ++n2;
        }
        return totalLength;
    }

    public NexusExtractor(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public NexusGroupData getAttributeOfCurrentProcessedGroup(String attrName) throws NexusException, NexusExtractorException {
        NexusGroupData val = null;
        try {
            this.file.opendata(this.currentGroupBeingProcessed.name);
            Hashtable dir = this.file.attrdir();
            Set set = dir.entrySet();
            for (Map.Entry entry : set) {
                Attr attr = new Attr((String)entry.getKey(), (AttributeEntry)entry.getValue());
                if (!attr.getName().equals(attrName)) continue;
                Group currentGroupBeingProcessed_tmp = this.currentGroupBeingProcessed;
                this.currentGroupBeingProcessed = attr;
                val = this.getDataForCurrentProcessedGroup(attr.getName(), attr.getNXclass(), true);
                this.currentGroupBeingProcessed = currentGroupBeingProcessed_tmp;
                break;
            }
        }
        finally {
            this.file.closedata();
        }
        return val;
    }

    @Override
    public NexusGroupData getDataForCurrentProcessedGroup(String name, String nxClass, boolean getData) throws NexusException, NexusExtractorException {
        if (this.currentGroupBeingProcessed == null || !this.currentGroupBeingProcessed.getName().equals(name) || !this.currentGroupBeingProcessed.getNXclass().equals(nxClass)) {
            throw new NexusExtractorException("getDataForCurrentProcessedGroup being called out of sequence");
        }
        boolean isAttr = this.currentGroupBeingProcessed instanceof Attr;
        int type = 0;
        int length = 0;
        if (isAttr) {
            type = ((Attr)this.currentGroupBeingProcessed).entry.type;
            length = ((Attr)this.currentGroupBeingProcessed).entry.length;
        }
        return NexusExtractor.getNexusGroupData(this.file, this.currentGroupBeingProcessed.name, name, getData, isAttr, type, length, null, null);
    }

    static NexusGroupData getNexusGroupData(NeXusFileInterface file, String currentGroupName, String attrName, boolean getData, boolean isAttr, int AttrType, int AttrLength, int[] startPos, int[] dims) throws NexusException, NexusExtractorException {
        if (!isAttr) {
            file.opendata(currentGroupName);
        }
        try {
            int[] infoDims = new int[10];
            int[] infoArgs = new int[10];
            if (isAttr) {
                infoArgs[0] = 1;
                infoArgs[1] = AttrType;
                infoDims[0] = AttrLength;
                if (infoArgs[1] == 4) {
                    infoDims[0] = infoDims[0] + 1;
                }
            } else {
                file.getinfo(infoDims, infoArgs);
            }
            int rank = infoArgs[0];
            int[] dimensions = new int[rank];
            int i = 0;
            while (i < rank) {
                dimensions[i] = infoDims[i];
                ++i;
            }
            int type = infoArgs[1];
            int lengthToSend = 0;
            long totalLength = NexusExtractor.calcTotalLengthLong(dimensions);
            if (!isAttr && startPos != null && dims != null) {
                if (startPos.length != dims.length || startPos.length != dimensions.length) {
                    throw new NexusExtractorException("startPos or dimensions of different rank than dataset");
                }
                dimensions = dims;
                long lengthRequested = NexusExtractor.calcTotalLengthLong(dimensions);
                if (lengthRequested > totalLength) {
                    throw new NexusExtractorException("requested chunk extends over dataset boundaries");
                }
                totalLength = lengthRequested;
            }
            if (!getData || totalLength <= 0L) {
                NexusGroupData nexusGroupData = new NexusGroupData(dimensions, type, null);
                return nexusGroupData;
            }
            if (totalLength > Integer.MAX_VALUE) {
                throw new NexusExtractorException("data size requested too big for java arrays");
            }
            lengthToSend = (int)totalLength;
            Object[] data = null;
            switch (type) {
                case 4: 
                case 20: 
                case 21: {
                    data = new byte[lengthToSend];
                    break;
                }
                case 22: 
                case 23: {
                    data = new short[lengthToSend];
                    break;
                }
                case 24: 
                case 25: {
                    data = new int[lengthToSend];
                    break;
                }
                case 26: 
                case 27: {
                    data = new long[lengthToSend];
                    break;
                }
                case 5: {
                    data = new float[lengthToSend];
                    break;
                }
                case 6: {
                    data = new double[lengthToSend];
                }
            }
            if (data == null) {
                throw new NexusExtractorException("Unable to getdata for " + currentGroupName + " as type " + Integer.toString(type) + " is not supported");
            }
            try {
                if (isAttr) {
                    int[] arg2 = new int[]{lengthToSend, type};
                    file.getattr(attrName, (Object)data, arg2);
                    if (infoArgs[1] == 4) {
                        dimensions[0] = dimensions[0] - 1;
                        data = Arrays.copyOf(data, dimensions[0]);
                    }
                } else if (startPos != null && dims != null) {
                    file.getslab(startPos, dimensions, (Object)data);
                } else {
                    file.getdata((Object)data);
                }
                NexusGroupData nexusGroupData = new NexusGroupData(dimensions, type, (Serializable)data);
                return nexusGroupData;
            }
            catch (NexusException ex) {
                logger.error("Error gettting data. totalLength=" + totalLength + " type = " + type);
                throw ex;
            }
        }
        finally {
            if (!isAttr) {
                file.closedata();
            }
        }
    }

    private INexusTreeProcessor.RESPONSE loop(Group group, IMonitor mon) throws NexusException, NexusExtractorException {
        if (mon != null && mon.isCancelled()) {
            return INexusTreeProcessor.RESPONSE.NO_MORE;
        }
        INexusTreeProcessor.RESPONSE response = INexusTreeProcessor.RESPONSE.GO_INTO;
        if (group.name.equals("UNKNOWN") && group.NXclass.equals("UNKNOWN")) {
            response = INexusTreeProcessor.RESPONSE.SKIP_OVER;
        } else {
            this.currentGroupBeingProcessed = group;
            response = this.loopProcessor.beginElement(group.name, group.NXclass, this);
            this.currentGroupBeingProcessed = null;
            if (response == INexusTreeProcessor.RESPONSE.NO_MORE || response == INexusTreeProcessor.RESPONSE.SKIP_OVER || response == INexusTreeProcessor.RESPONSE.SDS_ATTR) {
                if (response == INexusTreeProcessor.RESPONSE.SDS_ATTR) {
                    this.file.opendata(group.name);
                    try {
                        Hashtable dir = this.file.attrdir();
                        Set set = dir.entrySet();
                        for (Map.Entry entry : set) {
                            INexusTreeProcessor.RESPONSE response2 = this.loop(new Attr((String)entry.getKey(), (AttributeEntry)entry.getValue()), mon);
                            if (response2 != INexusTreeProcessor.RESPONSE.NO_MORE) continue;
                            response = INexusTreeProcessor.RESPONSE.NO_MORE;
                            break;
                        }
                    }
                    finally {
                        this.loopProcessor.endElement();
                        this.file.closedata();
                    }
                }
                return INexusTreeProcessor.RESPONSE.SKIP_OVER;
            }
        }
        if (!(group.name.isEmpty() && group.NXclass.isEmpty() || group.containsSDS())) {
            this.file.opengroup(group.name, group.NXclass);
        }
        try {
            try {
                INexusTreeProcessor.RESPONSE response2;
                Hashtable groupdir = this.file.groupdir();
                Hashtable attrdir = this.file.attrdir();
                Set set = groupdir.entrySet();
                for (Map.Entry entry : set) {
                    response2 = this.loop(new Group((String)entry.getKey(), (String)entry.getValue()), mon);
                    if (response2 != INexusTreeProcessor.RESPONSE.NO_MORE) continue;
                    response = INexusTreeProcessor.RESPONSE.NO_MORE;
                    break;
                }
                set = attrdir.entrySet();
                for (Map.Entry entry : set) {
                    response2 = this.loop(new Attr((String)entry.getKey(), (AttributeEntry)entry.getValue()), mon);
                    if (response2 != INexusTreeProcessor.RESPONSE.NO_MORE) continue;
                    response = INexusTreeProcessor.RESPONSE.NO_MORE;
                    break;
                }
            }
            catch (NexusException e) {
                logger.info(String.valueOf(e.getMessage()) + " " + group.toString());
                throw e;
            }
        }
        finally {
            if (!(group.name.isEmpty() && group.NXclass.isEmpty() || group.containsSDS())) {
                this.file.closegroup();
            }
            this.currentGroupBeingProcessed = null;
        }
        this.loopProcessor.endElement();
        return response;
    }

    public void runLoop(INexusTreeProcessor loopProcessor, boolean debug) throws NexusException, NexusExtractorException {
        this.runLoop(loopProcessor, debug, null);
    }

    public void runLoop(INexusTreeProcessor loopProcessor, boolean debug, IMonitor mon) throws NexusException, NexusExtractorException {
        this.loopProcessor = loopProcessor;
        this.file = new NexusFile(this.fileName, 1);
        if (debug) {
            this.file = new NexusFileWrapper(this.file);
        }
        try {
            this.loop(new Group("", ""), mon);
        }
        finally {
            if (this.file != null) {
                this.file.close();
            }
            this.currentGroupBeingProcessed = null;
        }
    }

    @Override
    public URL getSourceId() throws MalformedURLException {
        return new URL("file:" + new File(this.fileName).getAbsolutePath());
    }

    public static synchronized NexusGroupData getNexusGroupData(URL source, String nodePathWithClasses, int[] startPos, int[] dims, boolean debug) throws NexusException, NexusExtractorException {
        return new SimpleExtractor(source, nodePathWithClasses, startPos, dims, debug).getData();
    }

    public static NexusGroupData getNexusGroupDataWithBuffer(INexusTree node, boolean readIfNull) throws NexusException, NexusExtractorException {
        if ((node.getData() == null || node.getData().getBuffer() == null) && readIfNull) {
            INexusTree top = node;
            while (top.getParentNode() != null) {
                top = top.getParentNode();
            }
            if (top instanceof INexusSourceProvider) {
                URL source = ((INexusSourceProvider)((Object)top)).getSource();
                return NexusExtractor.getNexusGroupData(source, node.getNodePathWithClasses(), null, null, logger.isDebugEnabled());
            }
        }
        return node.getData();
    }

    public static NexusGroupData getNexusGroupDataSlab(INexusTree node, int[] startPos, int[] dims) throws NexusExtractorException, NexusException {
        INexusTree top = node;
        while (top.getParentNode() != null) {
            top = top.getParentNode();
        }
        if (!(top instanceof INexusSourceProvider)) {
            throw new NexusExtractorException("top node is not INexusSourceProvider");
        }
        URL source = ((INexusSourceProvider)((Object)top)).getSource();
        return NexusExtractor.getNexusGroupData(source, node.getNodePathWithClasses(), startPos, dims, logger.isDebugEnabled());
    }
}

