/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeBuilder;
import gda.data.nexus.tree.NexusTreeNode;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import gda.util.TestUtils;
import java.io.File;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.InputSource;
import uk.ac.gda.util.OSUtils;

public class NexusReadinTest {
    static String filename = "testfiles/gda/data/nexus/nexus-readin.nxs";

    @Test
    public void readValue() throws Exception {
        TestUtils.skipTestIf((boolean)OSUtils.is32bitJVM(), (String)(String.valueOf(this.getClass().getCanonicalName()) + ".readValue skipped, since this test fails in native code on a 32-bit machine"));
        assert (new File(filename).canRead());
        Assert.assertEquals((double)209.0, (double)this.getValue(), (double)0.0);
    }

    private double getValue() throws Exception {
        INexusTree tree_out2 = NexusTreeBuilder.getNexusTree(filename, this.getSelection());
        NexusTreeNode node = (NexusTreeNode)tree_out2.getChildNode(0).getChildNode("Wax", "NXdata").getChildNode(0);
        double[] data = (double[])node.groupData.getBuffer();
        return data[4 * node.groupData.dimensions[2] + 5];
    }

    public NexusTreeNodeSelection getSelection() throws Exception {
        String xml = "<?xml version='1.0' encoding='UTF-8'?><nexusTreeNodeSelection><nexusTreeNodeSelection><nxClass>NXentry</nxClass><wanted>1</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>NXdata</nxClass><name>.*</name><wanted>1</wanted><dataType>2</dataType><nexusTreeNodeSelection><nxClass>SDS</nxClass><name>data</name><wanted>1</wanted><dataType>2</dataType></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection></nexusTreeNodeSelection>";
        return NexusTreeNodeSelection.createFromXML(new InputSource(new StringReader(xml)));
    }
}

