/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import java.util.Hashtable;
import java.util.Vector;
import org.nexusformat.NXlink;
import org.nexusformat.NeXusFileInterface;
import org.nexusformat.NexusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NexusFileWrapper
implements NeXusFileInterface {
    private static final Logger logger = LoggerFactory.getLogger(NexusFileWrapper.class);
    NeXusFileInterface file;
    Vector<String> currentGroupNamePath = new Vector();
    Vector<String> currentGroupNXNamePath = new Vector();
    Vector<String> currentDataPath = new Vector();

    private String getCurrentGroupName() {
        return this.currentGroupNamePath.size() > 0 ? this.currentGroupNamePath.lastElement() : "top";
    }

    private String getCurrentGroupNXName() {
        return this.currentGroupNXNamePath.size() > 0 ? this.currentGroupNXNamePath.lastElement() : "top";
    }

    private String getCurrentGroup() {
        return String.valueOf(this.getCurrentGroupName()) + "-" + this.getCurrentGroupNXName();
    }

    private String getCurrentData() {
        return this.currentDataPath.size() > 0 ? this.currentDataPath.lastElement() : "top-data";
    }

    private String getCurrentAttrLocation() {
        return this.getCurrentData().equals("top-data") ? this.getCurrentGroup() : this.getCurrentData();
    }

    public NexusFileWrapper(NeXusFileInterface file) {
        this.file = file;
    }

    public void closedata() throws NexusException {
        String currentOpenedData = this.currentDataPath.lastElement();
        logger.debug("closedata - " + currentOpenedData);
        this.file.closedata();
        this.currentDataPath.remove(this.currentDataPath.size() - 1);
    }

    public void closegroup() throws NexusException {
        logger.debug("closegroup - " + this.getCurrentGroup());
        this.file.closegroup();
        this.currentGroupNamePath.remove(this.currentGroupNamePath.size() - 1);
        this.currentGroupNXNamePath.remove(this.currentGroupNXNamePath.size() - 1);
    }

    public void opendata(String arg0) throws NexusException {
        logger.debug("opendata - " + arg0);
        this.file.opendata(arg0);
        this.currentDataPath.add(arg0);
    }

    public void opengroup(String arg0, String arg1) throws NexusException {
        logger.debug("opengroup " + arg0 + " - " + arg1);
        this.file.opengroup(arg0, arg1);
        this.currentGroupNamePath.add(arg0);
        this.currentGroupNXNamePath.add(arg1);
    }

    public Hashtable attrdir() throws NexusException {
        logger.debug("attrdir - " + this.getCurrentAttrLocation());
        return this.file.attrdir();
    }

    public void close() throws NexusException {
        this.file.close();
    }

    public void compmakedata(String arg0, int arg1, int arg2, int[] arg3, int arg4, int[] arg5) throws NexusException {
        this.file.compmakedata(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public void compress(int arg0) throws NexusException {
        this.file.compress(arg0);
    }

    public boolean equals(Object obj) {
        return this.file.equals(obj);
    }

    public void finalize() throws Throwable {
        this.file.finalize();
    }

    public void flush() throws NexusException {
        this.file.flush();
    }

    public void getattr(String arg0, Object arg1, int[] arg2) throws NexusException {
        logger.debug("getattr - " + arg0);
        this.file.getattr(arg0, arg1, arg2);
    }

    public void getdata(Object arg0) throws NexusException {
        logger.debug("get - " + arg0);
        this.file.getdata(arg0);
    }

    public NXlink getdataID() throws NexusException {
        return this.file.getdataID();
    }

    public NXlink getgroupID() throws NexusException {
        return this.file.getgroupID();
    }

    public void getinfo(int[] arg0, int[] arg1) throws NexusException {
        this.file.getinfo(arg0, arg1);
    }

    public void getslab(int[] arg0, int[] arg1, Object arg2) throws NexusException {
        this.file.getslab(arg0, arg1, arg2);
    }

    public Hashtable groupdir() throws NexusException {
        logger.debug("groupdir - " + this.getCurrentGroup());
        return this.file.groupdir();
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String inquirefile() throws NexusException {
        return this.file.inquirefile();
    }

    public String isexternalgroup(String arg0, String arg1) throws NexusException {
        return this.file.isexternalgroup(arg0, arg1);
    }

    public void linkexternal(String arg0, String arg1, String arg2) throws NexusException {
        this.file.linkexternal(arg0, arg1, arg2);
    }

    public void makedata(String arg0, int arg1, int arg2, int[] arg3) throws NexusException {
        this.file.makedata(arg0, arg1, arg2, arg3);
    }

    public void makegroup(String arg0, String arg1) throws NexusException {
        this.file.makegroup(arg0, arg1);
    }

    public void makelink(NXlink arg0) throws NexusException {
        logger.debug("makelink - " + arg0.targetPath);
        this.file.makelink(arg0);
    }

    public void makenamedlink(String arg0, NXlink arg1) throws NexusException {
        this.file.makenamedlink(arg0, arg1);
    }

    public void opengrouppath(String arg0) throws NexusException {
        this.file.opengrouppath(arg0);
    }

    public void openpath(String arg0) throws NexusException {
        this.file.openpath(arg0);
    }

    public void opensourcepath() throws NexusException {
        this.file.opensourcepath();
    }

    public void putattr(String arg0, Object arg1, int arg2) throws NexusException {
        logger.debug("putattr - " + arg0 + " inside " + this.getCurrentAttrLocation());
        this.file.putattr(arg0, arg1, arg2);
    }

    public void putdata(Object arg0) throws NexusException {
        logger.debug("putdata inside " + this.getCurrentAttrLocation());
        this.file.putdata(arg0);
    }

    public void putslab(Object arg0, int[] arg1, int[] arg2) throws NexusException {
        logger.debug("putslab");
        this.file.putslab(arg0, arg1, arg2);
    }

    public void setnumberformat(int arg0, String arg1) throws NexusException {
        this.file.setnumberformat(arg0, arg1);
    }

    public String toString() {
        return this.file.toString();
    }

    public void compmakedata(String arg0, int arg1, int arg2, long[] arg3, int arg4, long[] arg5) throws NexusException {
        this.file.compmakedata(arg0, arg1, arg2, arg3, arg4, arg5);
    }

    public void getinfo(long[] arg0, int[] arg1) throws NexusException {
        this.file.getinfo(arg0, arg1);
    }

    public String getpath() throws NexusException {
        return this.file.getpath();
    }

    public void getslab(long[] arg0, long[] arg1, Object arg2) throws NexusException {
        this.file.getslab(arg0, arg1, arg2);
    }

    public String isexternaldataset(String arg0) throws NexusException {
        return this.file.isexternaldataset(arg0);
    }

    public void linkexternaldataset(String arg0, String arg1) throws NexusException {
        this.file.linkexternaldataset(arg0, arg1);
    }

    public void makedata(String arg0, int arg1, int arg2, long[] arg3) throws NexusException {
        this.file.makedata(arg0, arg1, arg2, arg3);
    }

    public void putslab(Object arg0, long[] arg1, long[] arg2) throws NexusException {
        this.file.putslab(arg0, arg1, arg2);
    }
}

