/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import gda.util.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nexusformat.NexusException;
import org.nexusformat.NexusFile;

public class NexusFileStressTest {
    static String testScratchDirectoryName;
    static String filename;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)NexusFileStressTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
        filename = String.valueOf(testScratchDirectoryName) + "file.nxs";
    }

    @Before
    public void deleteFile() {
        File handle = new File(filename);
        if (handle.isFile() && !handle.delete()) {
            Assert.fail((String)("Unable to delete file " + filename));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testConstructor() throws Exception {
        new NexusFile(null, 1);
    }

    @Test(expected=NullPointerException.class)
    public void testMakeGroupNPE1() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.makegroup(null, "NXentry");
            file.opengroup("entry1", "NXentry");
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testMakeGroupNPE2() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.makegroup("entry1", null);
            file.opengroup("entry1", "NXentry");
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testOpenGroupNPE1() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.opengroup(null, "NXentry");
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testOpenGroupNPE2() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.opengroup("entry1", null);
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testMakeDataNPE1() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.makegroup("entry1", "NXentry");
            file.opengroup("entry1", "NXentry");
            file.makedata(null, 6, 2, new int[]{1});
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testMakeDataNPE2() throws Exception {
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.makegroup("entry1", "NXentry");
            file.opengroup("entry1", "NXentry");
            file.makedata("data", 6, 2, null);
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NullPointerException.class)
    public void testMultiDimPutSlab() throws Exception {
        int[] dim = new int[]{512, 512};
        int numberOfPoints = 2;
        int rank = dim.length + 1;
        int[] dimArray = new int[rank];
        dimArray[0] = -1;
        int size = 1;
        int i = 0;
        while (i < dim.length) {
            dimArray[i + 1] = dim[i];
            size *= dim[i];
            ++i;
        }
        double[] data = new double[size];
        int[] startPos = new int[rank];
        NexusFile file = null;
        try {
            file = new NexusFile(filename, 5);
            file.makegroup("entry1", "NXentry");
            file.opengroup("entry1", "NXentry");
            file.makedata(null, 6, rank, dimArray);
            file.opendata("data");
            dimArray[0] = 1;
            int i2 = 0;
            while (i2 < numberOfPoints) {
                startPos[0] = i2++;
                file.putslab((Object)data, startPos, dimArray);
            }
            file.closedata();
            file.closegroup();
            file.closegroup();
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }

    @Test(expected=NexusException.class)
    public void testFileNotThere() throws Exception {
        this.deleteFile();
        NexusFile file = new NexusFile(filename, 1);
        file.opengroup("entry1", "NXentry");
        file.closegroup();
        file.close();
    }

    public static void main(String[] args) {
        try {
            NexusFileStressTest.setUpBeforeClass();
            NexusFileStressTest nfsst = new NexusFileStressTest();
            nfsst.testFileNotThere();
            System.err.println("not good - no exception");
        }
        catch (NexusException nexusException) {
            System.out.println("all good - expected behaviour");
        }
        catch (Exception e) {
            System.err.println("not so good - unexpected exception seen: " + e.getMessage());
        }
    }
}

