/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import gda.data.nexus.FileNameBufToStrings;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class FileNameBufToStringsTest {
    @Test
    public void testDim1() throws UnsupportedEncodingException {
        String dataFileName = "This is a test";
        byte[] buf = this.StringToByteArray(dataFileName);
        int[] dimensions = new int[]{255};
        String[] stringList = new FileNameBufToStrings(dimensions, buf).getFilenames();
        Assert.assertEquals((Object)dataFileName, (Object)stringList[0]);
    }

    private byte[] StringToByteArray(String dataFileName) {
        return this.StringToByteArray(new String[]{dataFileName}, new int[]{1});
    }

    private byte[] StringToByteArray(String[] dataFileNames, int[] dimensions) {
        int len = dataFileNames.length * 255;
        byte[] filenameBytes = new byte[len];
        Arrays.fill(filenameBytes, (byte)0);
        if (dimensions.length == 1) {
            int offset = 0;
            String[] stringArray = dataFileNames;
            int n = dataFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String dataFileName = stringArray[n2];
                int k = 0;
                while (k < dataFileName.length()) {
                    filenameBytes[k + offset] = (byte)dataFileName.charAt(k);
                    ++k;
                }
                offset += 255;
                ++n2;
            }
            return filenameBytes;
        }
        if (dimensions.length == 2) {
            int offset = 0;
            int i = 0;
            while (i < dimensions[0]) {
                int j = 0;
                while (j < dimensions[1]) {
                    String dataFileName = dataFileNames[i * dimensions[1] + j];
                    int k = 0;
                    while (k < dataFileName.length()) {
                        filenameBytes[k + offset] = (byte)dataFileName.charAt(k);
                        ++k;
                    }
                    offset += 255;
                    ++j;
                }
                ++i;
            }
            return filenameBytes;
        }
        return null;
    }

    @Test
    public void testDim2() throws UnsupportedEncodingException {
        String dataFileName = "This is a test";
        String dataFileName1 = "This is a test1";
        String[] dataFileNames = new String[]{dataFileName, dataFileName1};
        int[] dataFileNamesDimensions = new int[]{dataFileNames.length};
        byte[] buf = this.StringToByteArray(dataFileNames, dataFileNamesDimensions);
        int[] dimensions = new int[]{dataFileNames.length, 255};
        String[] stringList = new FileNameBufToStrings(dimensions, buf).getFilenames();
        Assert.assertEquals((Object)dataFileName, (Object)stringList[0]);
        Assert.assertEquals((Object)dataFileName1, (Object)stringList[1]);
    }

    @Test
    public void testDim3() throws UnsupportedEncodingException {
        String dataFileName1A = "This is a test1A";
        String dataFileName2A = "This is a test2A";
        String dataFileName1B = "This is a test1B";
        String dataFileName2B = "This is a test2B";
        String dataFileName1C = "This is a test1C";
        String dataFileName2C = "This is a test2C";
        String[] dataFileNames = new String[]{dataFileName1A, dataFileName1B, dataFileName1C, dataFileName2A, dataFileName2B, dataFileName2C};
        int[] dataFileNamesDimensions = new int[]{2, 3};
        byte[] buf = this.StringToByteArray(dataFileNames, dataFileNamesDimensions);
        int[] dimensions = new int[]{2, 3, 255};
        String[] stringList = new FileNameBufToStrings(dimensions, buf).getFilenames();
        Assert.assertEquals((Object)dataFileName1A, (Object)stringList[0]);
        Assert.assertEquals((Object)dataFileName1B, (Object)stringList[1]);
        Assert.assertEquals((Object)dataFileName1C, (Object)stringList[2]);
        Assert.assertEquals((Object)dataFileName2A, (Object)stringList[3]);
        Assert.assertEquals((Object)dataFileName2B, (Object)stringList[4]);
        Assert.assertEquals((Object)dataFileName2C, (Object)stringList[5]);
    }
}

