/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class FileNameBufToStrings {
    public static final int MAX_DATAFILENAME = 255;
    private int offset = 0;
    private int filenamesOffset = 0;
    private byte[] buffer = null;
    private String[] filenames = null;

    public String[] getFilenames() {
        return this.filenames;
    }

    public FileNameBufToStrings(int[] dimensions, byte[] buffer) throws UnsupportedEncodingException {
        this.buffer = buffer;
        if (dimensions == null || dimensions.length < 1) {
            throw new IllegalArgumentException("dimensions.length must be >=1");
        }
        int totalNumFileNames = 1;
        int i = 0;
        while (i < dimensions.length - 1) {
            totalNumFileNames *= dimensions[i];
            ++i;
        }
        if (totalNumFileNames != buffer.length / 255) {
            throw new IllegalArgumentException("buffer length does not match dimensions");
        }
        this.filenames = new String[totalNumFileNames];
        this.fillStringArray(dimensions);
    }

    private void fillStringArray(int[] dimensions) throws UnsupportedEncodingException {
        if (dimensions.length == 1) {
            if (255 > this.buffer.length - this.offset) {
                throw new IllegalArgumentException("buffer is not large enough for given dimensions");
            }
            int len = 255;
            int i = 0;
            while (i < 255) {
                if (this.buffer[i + this.offset] == 0) {
                    len = i;
                    break;
                }
                ++i;
            }
            this.filenames[this.filenamesOffset] = new String(this.buffer, this.offset, len, "UTF-8");
            this.offset += 255;
            ++this.filenamesOffset;
        } else {
            int iFilename = 0;
            while (iFilename < dimensions[0]) {
                int[] newDims = Arrays.copyOfRange(dimensions, 1, dimensions.length);
                this.fillStringArray(newDims);
                ++iFilename;
            }
        }
    }
}

