/*
 * Decompiled with CFR 0.152.
 */
package gda.data.nexus;

import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nexusformat.NexusFile;

public class DataTypesTest {
    static String testScratchDirectoryName;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)DataTypesTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testDouble() throws Exception {
        new GenericTest(this, 6, (Number[])new Double[]{0.0, -1.0, Double.MAX_VALUE});
    }

    @Test
    public void testByte() throws Exception {
        new GenericTest(this, 20, (Number[])new Byte[]{(byte)0, (byte)-1, (byte)127});
    }

    @Test
    public void testLong() throws Exception {
        new GenericTest(this, 26, (Number[])new Long[]{0L, -1L, Long.MAX_VALUE});
    }

    @Test
    public void testLongUnsigned() throws Exception {
        new GenericTest(this, 27, (Number[])new Long[]{0L, -1L, Long.MAX_VALUE});
    }

    @Test
    public void testInteger() throws Exception {
        new GenericTest(this, 24, (Number[])new Integer[]{0, -1, Integer.MAX_VALUE});
    }

    static class GenericTest<T extends Number> {
        final /* synthetic */ DataTypesTest this$0;

        GenericTest(int type, T[] toTest) throws Exception {
            this.this$0 = var1_1;
            Number[] expected = (Number[])toTest.clone();
            Number[] received = (Number[])toTest.clone();
            String filename = String.valueOf(testScratchDirectoryName) + "foo.nxs";
            NexusFile file = new NexusFile(filename, 5);
            file.makegroup("entry1", "NXentry");
            file.opengroup("entry1", "NXentry");
            file.makedata("data", type, 1, new int[]{toTest.length});
            file.opendata("data");
            file.putdata(toTest);
            file.closedata();
            file.closegroup();
            file.close();
            file = new NexusFile(filename, 1);
            file.opengroup("entry1", "NXentry");
            file.opendata("data");
            file.getdata((Object)received);
            file.closedata();
            file.closegroup();
            file.close();
            int i = 0;
            while (i < expected.length) {
                Assert.assertEquals((Object)expected[i], (Object)received[i]);
                ++i;
            }
        }
    }
}

