/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.editor;

import java.lang.reflect.InvocationTargetException;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.editor.H5ResourcePage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5Wizard
extends Wizard
implements INewWizard {
    private static Logger logger = LoggerFactory.getLogger(H5Wizard.class);
    private H5ResourcePage page;
    private IStructuredSelection selection;

    public H5Wizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new H5ResourcePage("Folder for H5 File", this.selection, H5ResourcePage.RESOURCE_CHOICE.PROJECT_AND_NAME, "empty_data_file.h5");
        this.addPage((IWizardPage)this.page);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        final IContainer iContainer = this.page.getProjectContainer();
        final String string = this.page.getSequenceName();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        H5Wizard.this.doFinish(iContainer, string, iProgressMonitor);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(IContainer iContainer, String string, IProgressMonitor iProgressMonitor) {
        try {
            iProgressMonitor.beginTask("Create " + string, 5);
            IFile iFile = iContainer instanceof IFolder ? ((IFolder)iContainer).getFile(string) : ((IProject)iContainer).getFile(string);
            HierarchicalDataFactory.create((String)iFile.getLocation().toOSString());
            iProgressMonitor.worked(1);
            iContainer.refreshLocal(1, iProgressMonitor);
        }
        catch (Exception exception) {
            logger.error("Cannot create sequence", (Throwable)exception);
        }
    }
}

