/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.editor;

import java.util.Arrays;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.IHierarchicalDataFile;
import org.dawb.hdf5.editor.H5Path;
import org.dawb.hdf5.editor.IH5Editor;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;

public class H5ValuePage
extends Page
implements ISelectionListener,
IPartListener {
    private static Logger logger = LoggerFactory.getLogger(H5ValuePage.class);
    protected CLabel label;
    protected SourceViewer sourceViewer;
    protected StructuredSelection lastSelection;
    protected Composite container;

    public void createControl(Composite composite) {
        this.container = new Composite(composite, 0);
        this.container.setLayout((Layout)new GridLayout(1, false));
        GridLayout gridLayout = (GridLayout)this.container.getLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.container.setBackground(composite.getDisplay().getSystemColor(1));
        this.label = new CLabel(this.container, 16384);
        this.label.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.label.setBackground(composite.getDisplay().getSystemColor(1));
        this.sourceViewer = new SourceViewer(this.container, null, 776);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.getTextWidget().setLayoutData((Object)new GridData(4, 4, true, true));
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        try {
            this.updateSelection(H5ValuePage.getActivePage().getSelection());
        }
        catch (Throwable throwable) {}
    }

    public Control getControl() {
        return this.container;
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
        this.lastSelection = null;
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        try {
            this.updateSelection(iSelection);
        }
        catch (Exception exception) {
            logger.error("Cannot update value", (Throwable)exception);
        }
    }

    protected void updateSelection(ISelection iSelection) throws Exception {
        if (iSelection instanceof StructuredSelection) {
            this.lastSelection = (StructuredSelection)iSelection;
            Object object = this.lastSelection.getFirstElement();
            this.updateObjectSelection(object);
            this.sourceViewer.refresh();
            this.label.getParent().layout(new Control[]{this.label, this.sourceViewer.getTextWidget()});
            return;
        }
        this.clear();
    }

    private void clear() {
        this.label.setText("");
        this.sourceViewer.getTextWidget().setText("");
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart == this) {
            try {
                this.updateSelection((ISelection)this.lastSelection);
            }
            catch (Throwable throwable) {}
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart iWorkbenchPart) {
    }

    public void updateObjectSelection(Object object) throws Exception {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof HObject) {
                this.createH5Value((HObject)object2);
            }
        } else if (object instanceof H5Path || object instanceof HDF5NodeLink) {
            try {
                String string = object instanceof H5Path ? ((H5Path)object).getPath() : ((HDF5NodeLink)object).getPath();
                IEditorPart iEditorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                if (iEditorPart instanceof IH5Editor) {
                    String string2 = ((IH5Editor)iEditorPart).getFilePath();
                    IHierarchicalDataFile iHierarchicalDataFile = HierarchicalDataFactory.getReader((String)string2);
                    HObject hObject = iHierarchicalDataFile.getData(string);
                    this.createH5Value(hObject);
                }
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
            }
        } else if (object instanceof HDF5Attribute) {
            this.sourceViewer.getTextWidget().setText(object.toString());
        }
    }

    private void createH5Value(HObject hObject) throws Exception {
        Object object;
        Object object2;
        Dataset dataset;
        if (hObject instanceof Dataset) {
            StringBuilder stringBuilder;
            block11: {
                dataset = (Dataset)hObject;
                object2 = dataset.getDatatype();
                object = dataset.getDims();
                stringBuilder = new StringBuilder();
                if (object2.getDatatypeClass() == 3) {
                    this.label.setText("Dataset name of '" + dataset.getName() + "' value:");
                    int n = dataset.open();
                    try {
                        try {
                            String[] stringArray = (String[])dataset.read();
                            stringBuilder.append(stringArray[0]);
                        }
                        catch (Exception exception) {
                            dataset.close(n);
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        dataset.close(n);
                        throw throwable;
                    }
                    dataset.close(n);
                } else if (object != null) {
                    this.label.setText("Dataset name of '" + dataset.getName() + "' shape:");
                    stringBuilder.append(Arrays.toString((long[])object));
                } else {
                    this.label.setText("Dataset name of '" + dataset.getName() + "'");
                }
            }
            this.appendAttributes((HObject)dataset, stringBuilder);
            this.sourceViewer.getTextWidget().setText(stringBuilder.toString());
        }
        if (hObject instanceof Group) {
            dataset = (Group)hObject;
            this.label.setText("Group name of '" + dataset.getName() + "' children:");
            object2 = dataset.getMemberList();
            object = object2 != null ? new StringBuilder(object2.toString()) : new StringBuilder();
            this.appendAttributes((HObject)dataset, (StringBuilder)object);
            this.sourceViewer.getTextWidget().setText(((StringBuilder)object).toString());
        }
    }

    private void appendAttributes(HObject hObject, StringBuilder stringBuilder) throws Exception {
        List list = hObject.getMetadata();
        if (list == null || list.isEmpty()) {
            return;
        }
        stringBuilder.append("\n\nAttributes:\n");
        for (Object e : list) {
            if (!(e instanceof Attribute)) continue;
            Attribute attribute = (Attribute)e;
            stringBuilder.append(attribute.getName());
            stringBuilder.append(" = ");
            stringBuilder.append(this.extractValue(attribute.getValue()));
            stringBuilder.append("\n");
        }
    }

    private Object extractValue(Object object) {
        if (object == null) {
            return "";
        }
        if (object.getClass().isArray()) {
            return H5ValuePage.toString(object);
        }
        return object.toString();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getActivePage();
    }

    private static Object toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof short[]) {
            return Arrays.toString((short[])object);
        }
        if (object instanceof int[]) {
            return Arrays.toString((int[])object);
        }
        if (object instanceof long[]) {
            return Arrays.toString((long[])object);
        }
        if (object instanceof char[]) {
            return Arrays.toString((char[])object);
        }
        if (object instanceof float[]) {
            return Arrays.toString((float[])object);
        }
        if (object instanceof double[]) {
            return Arrays.toString((double[])object);
        }
        if (object instanceof boolean[]) {
            return Arrays.toString((boolean[])object);
        }
        if (object instanceof byte[]) {
            return Arrays.toString((byte[])object);
        }
        if (object instanceof Object[]) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }
}

