/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.editor;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class H5ResourcePage
extends WizardDataTransferPage {
    private Text containerNameField;
    private Text folderNameField;
    private Text sequenceNameField;
    private IStructuredSelection selection;
    private RESOURCE_CHOICE choice;
    private String defaultName;

    protected H5ResourcePage(String string, IStructuredSelection iStructuredSelection, RESOURCE_CHOICE rESOURCE_CHOICE, String string2) {
        super(string);
        this.choice = rESOURCE_CHOICE;
        this.selection = iStructuredSelection;
        this.defaultName = string2;
        this.setTitle("Choose folder to import");
        this.setDescription("Choose a folder to create a data link in the project.");
    }

    private String getContainerPath(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection == null) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof IAdaptable) {
            IContainer iContainer = (IContainer)((IAdaptable)object).getAdapter(IContainer.class);
            return iContainer.getFullPath().toPortableString();
        }
        return null;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.createDestinationGroup(composite2);
        if (this.choice == RESOURCE_CHOICE.PROJECT_AND_EXTERNAL_FOLDER) {
            this.createFolderChoiceGroup(composite2);
        }
        if (this.choice == RESOURCE_CHOICE.PROJECT_AND_NAME) {
            this.createNameChoiceGroup(composite2);
        }
        this.setErrorMessage(null);
        this.setPageComplete(false);
        this.setControl((Control)composite2);
        this.dialogChanged();
    }

    private void createNameChoiceGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Sequence Name ");
        this.sequenceNameField = new Text(composite, 2052);
        this.sequenceNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sequenceNameField.setText(this.defaultName);
        this.sequenceNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                H5ResourcePage.this.dialogChanged();
            }
        });
    }

    protected final void createDestinationGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Parent Folder ");
        this.containerNameField = new Text(composite, 2052);
        this.containerNameField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        String string = this.getContainerPath(this.selection);
        if (string != null) {
            this.containerNameField.setText(string);
        }
        this.containerNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                H5ResourcePage.this.dialogChanged();
            }
        });
        Button button = new Button(composite, 8);
        button.setText("Browse...");
        button.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IPath iPath = H5ResourcePage.this.queryForContainer(H5ResourcePage.this.getSpecifiedContainer(), "Choose folder to import to", "Choose Folder");
                H5ResourcePage.this.containerNameField.setText(iPath.toString());
                H5ResourcePage.this.dialogChanged();
            }
        });
        this.setButtonLayoutData(button);
    }

    protected IPath queryForContainer(IContainer iContainer, String string, String string2) {
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getControl().getShell(), iContainer, false, string);
        if (string2 != null) {
            containerSelectionDialog.setTitle(string2);
        }
        containerSelectionDialog.showClosedProjects(false);
        containerSelectionDialog.open();
        Object[] objectArray = containerSelectionDialog.getResult();
        if (objectArray != null && objectArray.length == 1) {
            return (IPath)objectArray[0];
        }
        return null;
    }

    protected IContainer getSpecifiedContainer() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = this.getContainerFullPath();
        if (iWorkspace.getRoot().exists(iPath)) {
            IResource iResource = iWorkspace.getRoot().findMember(iPath);
            if (iResource.getType() == 1) {
                return null;
            }
            return (IContainer)iResource;
        }
        return null;
    }

    protected IPath getContainerFullPath() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IPath iPath = this.getResourcePath();
        if (iPath.equals((Object)iWorkspace.getRoot().getFullPath())) {
            return iPath;
        }
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 14);
        if (iStatus.isOK()) {
            return iPath;
        }
        return null;
    }

    protected IPath getResourcePath() {
        return this.getPathFromText(this.containerNameField);
    }

    private void createFolderChoiceGroup(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("External Folder");
        label.setFont(composite.getFont());
        this.folderNameField = new Text(composite, 2048);
        GridData gridData = new GridData(768);
        gridData.widthHint = 250;
        this.folderNameField.setLayoutData((Object)gridData);
        this.folderNameField.setFont(composite.getFont());
        this.folderNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                H5ResourcePage.this.dialogChanged();
            }
        });
        Button button = new Button(composite, 8);
        button.setText("Browse...");
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DirectoryDialog directoryDialog = new DirectoryDialog(H5ResourcePage.this.getControl().getShell());
                if (H5ResourcePage.this.folderNameField.getText() != null) {
                    directoryDialog.setFilterPath(H5ResourcePage.this.folderNameField.getText());
                }
                H5ResourcePage.this.folderNameField.setText(directoryDialog.open());
                H5ResourcePage.this.dialogChanged();
            }
        });
        button.setLayoutData((Object)new GridData(256));
        button.setFont(composite.getFont());
        this.setButtonLayoutData(button);
    }

    private void dialogChanged() {
        Object object;
        IContainer iContainer = this.getProjectContainer();
        if (iContainer == null) {
            this.updateStatus("Please select a valid parent project.");
            return;
        }
        if (this.choice == RESOURCE_CHOICE.PROJECT_AND_EXTERNAL_FOLDER) {
            object = this.getExternalFolder();
            if (object == null) {
                this.updateStatus("Please select a valid import folder.");
                return;
            }
            if (!((File)object).exists()) {
                this.updateStatus("Please select an existing folder.");
                return;
            }
            if (!((File)object).isDirectory()) {
                this.updateStatus("Please select directory not a file.");
                return;
            }
            if (iContainer.getFolder((IPath)new Path(String.valueOf(iContainer.getFullPath().toPortableString()) + "/" + ((File)object).getName())).exists()) {
                this.updateStatus("Please select a folder not existing or delete the existing folder with the name '" + ((File)object).getName() + "'");
                return;
            }
        }
        if (this.choice == RESOURCE_CHOICE.PROJECT_AND_NAME) {
            object = this.getSequenceName();
            if (object == null) {
                this.updateStatus("Please set a name for the resource to create.");
                return;
            }
            if (!((String)object).endsWith(H5ResourcePage.getFileExtension(this.defaultName))) {
                this.updateStatus("The sequence name must end with '" + H5ResourcePage.getFileExtension(this.defaultName) + "'");
                return;
            }
            if (iContainer.findMember((String)object) != null) {
                this.updateStatus("The file '" + (String)object + "' already exists.");
                return;
            }
        }
        this.updateStatus(null);
    }

    private static String getFileExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? "" : string.substring(n + 1);
    }

    public String getSequenceName() {
        String string = this.sequenceNameField.getText();
        if (string == null || "".equals(string)) {
            return null;
        }
        return string;
    }

    public File getExternalFolder() {
        String string = this.folderNameField.getText();
        if (string == null || "".equals(string)) {
            return null;
        }
        return new File(string);
    }

    public IContainer getProjectContainer() {
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            IPath iPath = this.getResourcePath();
            IResource iResource = iWorkspace.getRoot().findMember(iPath);
            return (IContainer)iResource;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public void handleEvent(Event event) {
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    public static enum RESOURCE_CHOICE {
        PROJECT_AND_NAME,
        PROJECT_AND_EXTERNAL_FOLDER;

    }
}

