/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.editor;

import java.text.DecimalFormat;
import java.util.Arrays;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import org.dawb.hdf5.HierarchicalDataUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5LabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private static final Logger logger = LoggerFactory.getLogger(H5LabelProvider.class);
    private static final double BASE = 1024.0;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public Image getColumnImage(Object object, int n) {
        return null;
    }

    public String getColumnText(Object object, int n) {
        if (!(object instanceof TreeNode)) {
            return null;
        }
        TreeNode treeNode = (TreeNode)object;
        HObject hObject = (HObject)((DefaultMutableTreeNode)treeNode).getUserObject();
        switch (n) {
            case 0: {
                return hObject.getName();
            }
            case 1: {
                if (hObject instanceof Group) {
                    return "Group";
                }
                if (hObject instanceof Dataset) {
                    return "Dataset";
                }
                return hObject.getClass().getConstructors()[0].getName();
            }
            case 2: {
                if (hObject instanceof Dataset) {
                    long[] lArray;
                    try {
                        lArray = HierarchicalDataUtils.getDims((Dataset)((Dataset)hObject));
                    }
                    catch (Exception exception) {
                        return "";
                    }
                    if (lArray == null) {
                        return "";
                    }
                    return Arrays.toString(lArray);
                }
                return "";
            }
            case 3: {
                if (hObject instanceof Dataset) {
                    return ((Dataset)hObject).getDatatype().getDatatypeDescription();
                }
                return "";
            }
            case 4: {
                if (hObject instanceof Dataset) {
                    long l;
                    try {
                        l = HierarchicalDataUtils.getSize((Dataset)((Dataset)hObject));
                    }
                    catch (Exception exception) {
                        return "";
                    }
                    if (l < 0L) {
                        return "";
                    }
                    return H5LabelProvider.formatSize(l);
                }
                return "";
            }
        }
        return null;
    }

    public static String formatSize(double d) {
        if (d >= 1.073741824E9) {
            return String.valueOf(df.format(d / 1.073741824E9)) + " GB";
        }
        if (d >= 1048576.0) {
            return String.valueOf(df.format(d / 1048576.0)) + " MB";
        }
        if (d >= 1024.0) {
            return String.valueOf(df.format(d / 1024.0)) + " KB";
        }
        return (int)d + " bytes";
    }
}

