/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.hdf5.editor;

import javax.swing.tree.TreeNode;
import org.dawb.hdf5.HierarchicalDataFactory;
import org.dawb.hdf5.IHierarchicalDataFile;
import org.dawb.hdf5.editor.H5ContentProvider;
import org.dawb.hdf5.editor.H5LabelProvider;
import org.dawb.hdf5.editor.H5SelectionProvider;
import org.dawb.hdf5.editor.H5ValuePage;
import org.dawb.hdf5.editor.IH5DoubleClickSelectionProvider;
import org.dawb.hdf5.editor.IH5Editor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H5Editor
extends EditorPart
implements IReusableEditor,
IH5Editor {
    public static final String ID = "org.dawb.hdf5.editor.raw.tree";
    private static final Logger logger = LoggerFactory.getLogger(H5Editor.class);
    private IHierarchicalDataFile file;
    private TreeViewer tree;

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        try {
            this.file = HierarchicalDataFactory.getReader((String)this.getFilePath(iEditorInput));
        }
        catch (Exception exception) {
            logger.error("Cannot open h5 file " + this.getFilePath(iEditorInput), (Throwable)exception);
        }
    }

    public void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        this.setPartName(iEditorInput.getName());
        try {
            this.file.close();
        }
        catch (Exception exception) {
            logger.error("Cannot close file " + this.file.getPath());
        }
        try {
            this.file = HierarchicalDataFactory.getReader((String)this.getFilePath(iEditorInput));
        }
        catch (Exception exception) {
            logger.error("Cannot open h5 file " + this.getFilePath(iEditorInput), (Throwable)exception);
        }
        this.refresh();
    }

    public String getFilePath(IEditorInput iEditorInput) {
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile != null) {
            return iFile.getLocation().toOSString();
        }
        if (iEditorInput instanceof IURIEditorInput) {
            String string = ((IURIEditorInput)iEditorInput).getURI().toString();
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            string = string.replace("%20", " ");
            return string;
        }
        return null;
    }

    public void createPartControl(Composite composite) {
        composite.setLayout((Layout)new GridLayout(1, false));
        this.tree = new TreeViewer(composite, 0x10000800);
        this.tree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setUseHashlookup(true);
        String[] stringArray = new String[]{"Name", "Class", "Dims", "Description", "Size"};
        int[] nArray = new int[]{250, 120, 80, 150, 150};
        int n = 0;
        while (n < stringArray.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.tree, 0);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(stringArray[n]);
            treeColumn.setWidth(nArray[n]);
            treeColumn.setMoveable(true);
            ++n;
        }
        H5SelectionProvider h5SelectionProvider = new H5SelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)h5SelectionProvider);
        this.createTreeListeners(h5SelectionProvider);
    }

    public void dispose() {
        try {
            super.dispose();
        }
        catch (Throwable throwable) {
            try {
                this.file.close();
            }
            catch (Exception exception) {
                logger.error("Cannot close file " + this.file.getPath());
            }
            throw throwable;
        }
        try {
            this.file.close();
        }
        catch (Exception exception) {
            logger.error("Cannot close file " + this.file.getPath());
        }
    }

    public void setFocus() {
        if (this.tree.getContentProvider() == null) {
            this.refresh();
        }
        this.tree.getControl().setFocus();
    }

    private void refresh() {
        TreeNode treeNode = this.file.getNode();
        this.tree.getTree().setItemCount(treeNode.getChildCount());
        this.tree.setUseHashlookup(true);
        this.tree.setContentProvider((IContentProvider)new H5ContentProvider());
        this.tree.setLabelProvider((IBaseLabelProvider)new H5LabelProvider());
        this.tree.setInput((Object)treeNode);
        this.tree.expandToLevel(1);
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == IContentProvider.class) {
            return new H5ValuePage();
        }
        return super.getAdapter(clazz);
    }

    @Override
    public String getFilePath() {
        return this.getFilePath(this.getEditorInput());
    }

    private void createTreeListeners(final H5SelectionProvider h5SelectionProvider) {
        this.tree.getControl().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                h5SelectionProvider.setSelection(H5Editor.this.tree.getSelection());
            }
        });
        this.tree.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                IConfigurationElement[] iConfigurationElementArray;
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.dawb.hdf5.editor.double.click.listener");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block6: {
                        ISelection iSelection;
                        IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                        IH5DoubleClickSelectionProvider iH5DoubleClickSelectionProvider = null;
                        try {
                            iH5DoubleClickSelectionProvider = (IH5DoubleClickSelectionProvider)iConfigurationElement.createExecutableExtension("class");
                        }
                        catch (CoreException coreException) {
                            break block6;
                        }
                        try {
                            iSelection = iH5DoubleClickSelectionProvider.getSelection(H5Editor.this.tree.getSelection(), H5Editor.this.getFilePath());
                        }
                        catch (Exception exception) {
                            logger.error("Cannot translate exception!", (Throwable)exception);
                            break block6;
                        }
                        if (iSelection != null) {
                            h5SelectionProvider.setSelection(iSelection);
                            return;
                        }
                    }
                    ++n2;
                }
            }
        });
    }
}

