/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

import com.JLex.CAccept;
import com.JLex.CDTrans;
import com.JLex.CEmit;
import com.JLex.CError;
import com.JLex.CInput;
import com.JLex.CMakeNfa;
import com.JLex.CMinimize;
import com.JLex.CNfa;
import com.JLex.CNfa2Dfa;
import com.JLex.CSet;
import com.JLex.CSpec;
import com.JLex.CUtility;
import com.JLex.JavaLexBitSet;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class CLexGen {
    private InputStream m_instream = null;
    private DataOutputStream m_outstream = null;
    private CInput m_input;
    private Hashtable m_tokens;
    private CSpec m_spec;
    private boolean m_init_flag;
    private CMakeNfa m_makeNfa;
    private CNfa2Dfa m_nfa2dfa;
    private CMinimize m_minimize;
    private CEmit m_emit;
    private static final boolean ERROR = false;
    private static final boolean NOT_ERROR = true;
    private static final int BUFFER_SIZE = 1024;
    static final int EOS = 1;
    static final int ANY = 2;
    static final int AT_BOL = 3;
    static final int AT_EOL = 4;
    static final int CCL_END = 5;
    static final int CCL_START = 6;
    static final int CLOSE_CURLY = 7;
    static final int CLOSE_PAREN = 8;
    static final int CLOSURE = 9;
    static final int DASH = 10;
    static final int END_OF_INPUT = 11;
    static final int L = 12;
    static final int OPEN_CURLY = 13;
    static final int OPEN_PAREN = 14;
    static final int OPTIONAL = 15;
    static final int OR = 16;
    static final int PLUS_CLOSE = 17;
    private static final int CLASS_CODE = 0;
    private static final int INIT_CODE = 1;
    private static final int EOF_CODE = 2;
    private static final int INIT_THROW_CODE = 3;
    private static final int YYLEX_THROW_CODE = 4;
    private static final int EOF_THROW_CODE = 5;
    private static final int EOF_VALUE_CODE = 6;
    private char[] m_state_dir;
    private char[] m_char_dir;
    private char[] m_line_dir;
    private char[] m_cup_dir;
    private char[] m_class_dir;
    private char[] m_implements_dir;
    private char[] m_function_dir;
    private char[] m_type_dir;
    private char[] m_integer_dir;
    private char[] m_intwrap_dir;
    private char[] m_full_dir;
    private char[] m_unicode_dir;
    private char[] m_ignorecase_dir;
    private char[] m_notunix_dir;
    private char[] m_init_code_dir;
    private char[] m_init_code_end_dir;
    private char[] m_init_throw_code_dir;
    private char[] m_init_throw_code_end_dir;
    private char[] m_yylex_throw_code_dir;
    private char[] m_yylex_throw_code_end_dir;
    private char[] m_eof_code_dir;
    private char[] m_eof_code_end_dir;
    private char[] m_eof_value_code_dir;
    private char[] m_eof_value_code_end_dir;
    private char[] m_eof_throw_code_dir;
    private char[] m_eof_throw_code_end_dir;
    private char[] m_class_code_dir;
    private char[] m_class_code_end_dir;
    private char[] m_yyeof_dir;
    private char[] m_public_dir;
    private JavaLexBitSet all_states;
    private boolean m_advance_stop;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CLexGen(String filename) throws FileNotFoundException, IOException {
        char[] cArray = new char[7];
        cArray[0] = 37;
        cArray[1] = 115;
        cArray[2] = 116;
        cArray[3] = 97;
        cArray[4] = 116;
        cArray[5] = 101;
        this.m_state_dir = cArray;
        char[] cArray2 = new char[6];
        cArray2[0] = 37;
        cArray2[1] = 99;
        cArray2[2] = 104;
        cArray2[3] = 97;
        cArray2[4] = 114;
        this.m_char_dir = cArray2;
        char[] cArray3 = new char[6];
        cArray3[0] = 37;
        cArray3[1] = 108;
        cArray3[2] = 105;
        cArray3[3] = 110;
        cArray3[4] = 101;
        this.m_line_dir = cArray3;
        char[] cArray4 = new char[5];
        cArray4[0] = 37;
        cArray4[1] = 99;
        cArray4[2] = 117;
        cArray4[3] = 112;
        this.m_cup_dir = cArray4;
        char[] cArray5 = new char[7];
        cArray5[0] = 37;
        cArray5[1] = 99;
        cArray5[2] = 108;
        cArray5[3] = 97;
        cArray5[4] = 115;
        cArray5[5] = 115;
        this.m_class_dir = cArray5;
        char[] cArray6 = new char[12];
        cArray6[0] = 37;
        cArray6[1] = 105;
        cArray6[2] = 109;
        cArray6[3] = 112;
        cArray6[4] = 108;
        cArray6[5] = 101;
        cArray6[6] = 109;
        cArray6[7] = 101;
        cArray6[8] = 110;
        cArray6[9] = 116;
        cArray6[10] = 115;
        this.m_implements_dir = cArray6;
        char[] cArray7 = new char[10];
        cArray7[0] = 37;
        cArray7[1] = 102;
        cArray7[2] = 117;
        cArray7[3] = 110;
        cArray7[4] = 99;
        cArray7[5] = 116;
        cArray7[6] = 105;
        cArray7[7] = 111;
        cArray7[8] = 110;
        this.m_function_dir = cArray7;
        char[] cArray8 = new char[6];
        cArray8[0] = 37;
        cArray8[1] = 116;
        cArray8[2] = 121;
        cArray8[3] = 112;
        cArray8[4] = 101;
        this.m_type_dir = cArray8;
        char[] cArray9 = new char[9];
        cArray9[0] = 37;
        cArray9[1] = 105;
        cArray9[2] = 110;
        cArray9[3] = 116;
        cArray9[4] = 101;
        cArray9[5] = 103;
        cArray9[6] = 101;
        cArray9[7] = 114;
        this.m_integer_dir = cArray9;
        char[] cArray10 = new char[9];
        cArray10[0] = 37;
        cArray10[1] = 105;
        cArray10[2] = 110;
        cArray10[3] = 116;
        cArray10[4] = 119;
        cArray10[5] = 114;
        cArray10[6] = 97;
        cArray10[7] = 112;
        this.m_intwrap_dir = cArray10;
        char[] cArray11 = new char[6];
        cArray11[0] = 37;
        cArray11[1] = 102;
        cArray11[2] = 117;
        cArray11[3] = 108;
        cArray11[4] = 108;
        this.m_full_dir = cArray11;
        char[] cArray12 = new char[9];
        cArray12[0] = 37;
        cArray12[1] = 117;
        cArray12[2] = 110;
        cArray12[3] = 105;
        cArray12[4] = 99;
        cArray12[5] = 111;
        cArray12[6] = 100;
        cArray12[7] = 101;
        this.m_unicode_dir = cArray12;
        char[] cArray13 = new char[12];
        cArray13[0] = 37;
        cArray13[1] = 105;
        cArray13[2] = 103;
        cArray13[3] = 110;
        cArray13[4] = 111;
        cArray13[5] = 114;
        cArray13[6] = 101;
        cArray13[7] = 99;
        cArray13[8] = 97;
        cArray13[9] = 115;
        cArray13[10] = 101;
        this.m_ignorecase_dir = cArray13;
        char[] cArray14 = new char[9];
        cArray14[0] = 37;
        cArray14[1] = 110;
        cArray14[2] = 111;
        cArray14[3] = 116;
        cArray14[4] = 117;
        cArray14[5] = 110;
        cArray14[6] = 105;
        cArray14[7] = 120;
        this.m_notunix_dir = cArray14;
        char[] cArray15 = new char[7];
        cArray15[0] = 37;
        cArray15[1] = 105;
        cArray15[2] = 110;
        cArray15[3] = 105;
        cArray15[4] = 116;
        cArray15[5] = 123;
        this.m_init_code_dir = cArray15;
        char[] cArray16 = new char[7];
        cArray16[0] = 37;
        cArray16[1] = 105;
        cArray16[2] = 110;
        cArray16[3] = 105;
        cArray16[4] = 116;
        cArray16[5] = 125;
        this.m_init_code_end_dir = cArray16;
        char[] cArray17 = new char[12];
        cArray17[0] = 37;
        cArray17[1] = 105;
        cArray17[2] = 110;
        cArray17[3] = 105;
        cArray17[4] = 116;
        cArray17[5] = 116;
        cArray17[6] = 104;
        cArray17[7] = 114;
        cArray17[8] = 111;
        cArray17[9] = 119;
        cArray17[10] = 123;
        this.m_init_throw_code_dir = cArray17;
        char[] cArray18 = new char[12];
        cArray18[0] = 37;
        cArray18[1] = 105;
        cArray18[2] = 110;
        cArray18[3] = 105;
        cArray18[4] = 116;
        cArray18[5] = 116;
        cArray18[6] = 104;
        cArray18[7] = 114;
        cArray18[8] = 111;
        cArray18[9] = 119;
        cArray18[10] = 125;
        this.m_init_throw_code_end_dir = cArray18;
        char[] cArray19 = new char[13];
        cArray19[0] = 37;
        cArray19[1] = 121;
        cArray19[2] = 121;
        cArray19[3] = 108;
        cArray19[4] = 101;
        cArray19[5] = 120;
        cArray19[6] = 116;
        cArray19[7] = 104;
        cArray19[8] = 114;
        cArray19[9] = 111;
        cArray19[10] = 119;
        cArray19[11] = 123;
        this.m_yylex_throw_code_dir = cArray19;
        char[] cArray20 = new char[13];
        cArray20[0] = 37;
        cArray20[1] = 121;
        cArray20[2] = 121;
        cArray20[3] = 108;
        cArray20[4] = 101;
        cArray20[5] = 120;
        cArray20[6] = 116;
        cArray20[7] = 104;
        cArray20[8] = 114;
        cArray20[9] = 111;
        cArray20[10] = 119;
        cArray20[11] = 125;
        this.m_yylex_throw_code_end_dir = cArray20;
        char[] cArray21 = new char[6];
        cArray21[0] = 37;
        cArray21[1] = 101;
        cArray21[2] = 111;
        cArray21[3] = 102;
        cArray21[4] = 123;
        this.m_eof_code_dir = cArray21;
        char[] cArray22 = new char[6];
        cArray22[0] = 37;
        cArray22[1] = 101;
        cArray22[2] = 111;
        cArray22[3] = 102;
        cArray22[4] = 125;
        this.m_eof_code_end_dir = cArray22;
        char[] cArray23 = new char[9];
        cArray23[0] = 37;
        cArray23[1] = 101;
        cArray23[2] = 111;
        cArray23[3] = 102;
        cArray23[4] = 118;
        cArray23[5] = 97;
        cArray23[6] = 108;
        cArray23[7] = 123;
        this.m_eof_value_code_dir = cArray23;
        char[] cArray24 = new char[9];
        cArray24[0] = 37;
        cArray24[1] = 101;
        cArray24[2] = 111;
        cArray24[3] = 102;
        cArray24[4] = 118;
        cArray24[5] = 97;
        cArray24[6] = 108;
        cArray24[7] = 125;
        this.m_eof_value_code_end_dir = cArray24;
        char[] cArray25 = new char[11];
        cArray25[0] = 37;
        cArray25[1] = 101;
        cArray25[2] = 111;
        cArray25[3] = 102;
        cArray25[4] = 116;
        cArray25[5] = 104;
        cArray25[6] = 114;
        cArray25[7] = 111;
        cArray25[8] = 119;
        cArray25[9] = 123;
        this.m_eof_throw_code_dir = cArray25;
        char[] cArray26 = new char[11];
        cArray26[0] = 37;
        cArray26[1] = 101;
        cArray26[2] = 111;
        cArray26[3] = 102;
        cArray26[4] = 116;
        cArray26[5] = 104;
        cArray26[6] = 114;
        cArray26[7] = 111;
        cArray26[8] = 119;
        cArray26[9] = 125;
        this.m_eof_throw_code_end_dir = cArray26;
        char[] cArray27 = new char[3];
        cArray27[0] = 37;
        cArray27[1] = 123;
        this.m_class_code_dir = cArray27;
        char[] cArray28 = new char[3];
        cArray28[0] = 37;
        cArray28[1] = 125;
        this.m_class_code_end_dir = cArray28;
        char[] cArray29 = new char[7];
        cArray29[0] = 37;
        cArray29[1] = 121;
        cArray29[2] = 121;
        cArray29[3] = 101;
        cArray29[4] = 111;
        cArray29[5] = 102;
        this.m_yyeof_dir = cArray29;
        char[] cArray30 = new char[8];
        cArray30[0] = 37;
        cArray30[1] = 112;
        cArray30[2] = 117;
        cArray30[3] = 98;
        cArray30[4] = 108;
        cArray30[5] = 105;
        cArray30[6] = 99;
        this.m_public_dir = cArray30;
        this.all_states = null;
        this.m_advance_stop = false;
        this.m_init_flag = false;
        try {
            this.m_instream = new FileInputStream(filename);
            if (this.m_instream == null) {
                System.out.println("Error: Unable to open input file " + filename + ".");
                return;
            }
            this.m_outstream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(filename) + ".java")));
            if (this.m_outstream == null) {
                System.out.println("Error: Unable to open output file " + filename + ".java.");
                return;
            }
            this.m_input = new CInput(this.m_instream);
            this.m_tokens = new Hashtable();
            this.m_tokens.put(Character.valueOf('$'), 4);
            this.m_tokens.put(Character.valueOf('('), 14);
            this.m_tokens.put(Character.valueOf(')'), 8);
            this.m_tokens.put(Character.valueOf('*'), 9);
            this.m_tokens.put(Character.valueOf('+'), 17);
            this.m_tokens.put(Character.valueOf('-'), 10);
            this.m_tokens.put(Character.valueOf('.'), 2);
            this.m_tokens.put(Character.valueOf('?'), 15);
            this.m_tokens.put(Character.valueOf('['), 6);
            this.m_tokens.put(Character.valueOf(']'), 5);
            this.m_tokens.put(Character.valueOf('^'), 3);
            this.m_tokens.put(Character.valueOf('{'), 13);
            this.m_tokens.put(Character.valueOf('|'), 16);
            this.m_tokens.put(Character.valueOf('}'), 7);
            this.m_spec = new CSpec(this);
            this.m_nfa2dfa = new CNfa2Dfa();
            this.m_minimize = new CMinimize();
            this.m_makeNfa = new CMakeNfa();
            this.m_emit = new CEmit();
            this.m_init_flag = true;
            return;
        }
        finally {
            if (this.m_instream != null) {
                try {
                    this.m_instream.close();
                }
                catch (Throwable throwable) {
                    System.out.println("Ignoring failure to close stream on " + filename);
                    throwable.printStackTrace();
                }
            }
            this.m_instream = null;
            if (this.m_outstream != null) {
                try {
                    this.m_outstream.close();
                }
                catch (Throwable throwable) {
                    System.out.println("Ignoring failure to close stream on " + filename + ".java");
                    throwable.printStackTrace();
                }
            }
            this.m_outstream = null;
        }
    }

    void generate() throws IOException, FileNotFoundException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_init_flag);
        if (this.m_spec.m_verbose) {
            System.out.println("Processing first section -- user code.");
        }
        this.userCode();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing second section -- JLex declarations.");
        }
        this.userDeclare();
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        if (this.m_spec.m_verbose) {
            System.out.println("Processing third section -- lexical rules.");
        }
        this.userRules();
        if (this.m_spec.m_verbose) {
            System.out.println("Outputting lexical analyzer code.");
        }
        this.m_emit.emit(this.m_spec, this.m_outstream);
        boolean cfr_ignored_0 = this.m_spec.m_verbose;
        this.m_outstream.close();
    }

    private void userCode() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, 0);
        }
        while (true) {
            if (this.m_input.getLine()) {
                CError.parse_error(11, 0);
            }
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                this.m_input.m_line_index = this.m_input.m_line_read;
                return;
            }
            this.m_outstream.writeBytes(new String(this.m_input.m_line, 0, this.m_input.m_line_read));
        }
    }

    private char[] getName() {
        while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
        }
        if (this.m_input.m_line_index >= this.m_input.m_line_read) {
            CError.parse_error(12, 0);
        }
        int elem = this.m_input.m_line_index;
        while (elem < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[elem])) {
            ++elem;
        }
        char[] buffer = new char[elem - this.m_input.m_line_index];
        elem = 0;
        while (this.m_input.m_line_index < this.m_input.m_line_read && !CUtility.isnewline(this.m_input.m_line[this.m_input.m_line_index])) {
            buffer[elem] = this.m_input.m_line[this.m_input.m_line_index];
            ++elem;
            ++this.m_input.m_line_index;
        }
        return buffer;
    }

    /*
     * Unable to fully structure code
     */
    private char[] packCode(char[] start_dir, char[] end_dir, char[] prev_code, int prev_read, int specified) throws IOException {
        CUtility.cuassert(1 == specified || specified == 0 || 2 == specified || 6 == specified || 3 == specified || 4 == specified || 5 == specified);
        if (CUtility.charncmp(this.m_input.m_line, 0, start_dir, 0, start_dir.length - 1) != 0) {
            CError.parse_error(13, 0);
        }
        if (prev_code == null) {
            prev_code = new char[1024];
            prev_read = 0;
        }
        if (prev_read >= prev_code.length) {
            prev_code = CUtility.doubleSize(prev_code);
        }
        this.m_input.m_line_index = start_dir.length - 1;
        block9: while (true) {
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_input.getLine()) {
                    CError.parse_error(11, this.m_input.m_line_number);
                }
                if (CUtility.charncmp(this.m_input.m_line, 0, end_dir, 0, end_dir.length - 1) != 0) continue;
                this.m_input.m_line_index = end_dir.length - 1;
                switch (specified) {
                    case 0: {
                        this.m_spec.m_class_read = prev_read;
                        break;
                    }
                    case 1: {
                        this.m_spec.m_init_read = prev_read;
                        break;
                    }
                    case 2: {
                        this.m_spec.m_eof_read = prev_read;
                        break;
                    }
                    case 6: {
                        this.m_spec.m_eof_value_read = prev_read;
                        break;
                    }
                    case 3: {
                        this.m_spec.m_init_throw_read = prev_read;
                        break;
                    }
                    case 4: {
                        this.m_spec.m_yylex_throw_read = prev_read;
                        break;
                    }
                    case 5: {
                        this.m_spec.m_eof_throw_read = prev_read;
                        break;
                    }
                    default: {
                        CError.parse_error(13, this.m_input.m_line_number);
                    }
                }
                return prev_code;
            }
            while (true) {
                if (this.m_input.m_line_index < this.m_input.m_line_read) ** break;
                continue block9;
                prev_code[prev_read] = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
                if (++prev_read < prev_code.length) continue;
                prev_code = CUtility.doubleSize(prev_code);
            }
            break;
        }
    }

    private void userDeclare() throws IOException {
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        if (this.m_input.m_eof_reached) {
            CError.parse_error(11, this.m_input.m_line_number);
        }
        while (!this.m_input.getLine()) {
            if (2 <= this.m_input.m_line_read && '%' == this.m_input.m_line[0] && '%' == this.m_input.m_line[1]) {
                int elem = 0;
                while (elem < this.m_input.m_line.length - 2) {
                    this.m_input.m_line[elem] = this.m_input.m_line[elem + 2];
                    ++elem;
                }
                this.m_input.m_line_read -= 2;
                this.m_input.m_pushback_line = true;
                if (this.m_input.m_line_read == 0 || '\r' == this.m_input.m_line[0] || '\n' == this.m_input.m_line[0]) {
                    this.m_input.m_pushback_line = false;
                }
                return;
            }
            if (this.m_input.m_line_read == 0) continue;
            if ('%' == this.m_input.m_line[0]) {
                if (1 >= this.m_input.m_line_read) {
                    CError.parse_error(12, this.m_input.m_line_number);
                    continue;
                }
                switch (this.m_input.m_line[1]) {
                    case '{': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_class_code_dir, 0, this.m_class_code_dir.length - 1) == 0) {
                            this.m_spec.m_class_code = this.packCode(this.m_class_code_dir, this.m_class_code_end_dir, this.m_spec.m_class_code, this.m_spec.m_class_read, 0);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'c': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_char_dir, 0, this.m_char_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_char_dir.length;
                            this.m_spec.m_count_chars = true;
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_class_dir, 0, this.m_class_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_class_dir.length;
                            this.m_spec.m_class_name = this.getName();
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_cup_dir, 0, this.m_cup_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_cup_dir.length;
                            this.m_spec.m_cup_compatible = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'e': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_code_dir, 0, this.m_eof_code_dir.length - 1) == 0) {
                            this.m_spec.m_eof_code = this.packCode(this.m_eof_code_dir, this.m_eof_code_end_dir, this.m_spec.m_eof_code, this.m_spec.m_eof_read, 2);
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_value_code_dir, 0, this.m_eof_value_code_dir.length - 1) == 0) {
                            this.m_spec.m_eof_value_code = this.packCode(this.m_eof_value_code_dir, this.m_eof_value_code_end_dir, this.m_spec.m_eof_value_code, this.m_spec.m_eof_value_read, 6);
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_eof_throw_code_dir, 0, this.m_eof_throw_code_dir.length - 1) == 0) {
                            this.m_spec.m_eof_throw_code = this.packCode(this.m_eof_throw_code_dir, this.m_eof_throw_code_end_dir, this.m_spec.m_eof_throw_code, this.m_spec.m_eof_throw_read, 5);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'f': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_function_dir, 0, this.m_function_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_function_dir.length;
                            this.m_spec.m_function_name = this.getName();
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_full_dir, 0, this.m_full_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_full_dir.length;
                            this.m_spec.m_dtrans_ncols = 257;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'i': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_integer_dir, 0, this.m_integer_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_integer_type = true;
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_intwrap_dir, 0, this.m_intwrap_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_integer_dir.length;
                            this.m_spec.m_intwrap_type = true;
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_init_code_dir, 0, this.m_init_code_dir.length - 1) == 0) {
                            this.m_spec.m_init_code = this.packCode(this.m_init_code_dir, this.m_init_code_end_dir, this.m_spec.m_init_code, this.m_spec.m_init_read, 1);
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_init_throw_code_dir, 0, this.m_init_throw_code_dir.length - 1) == 0) {
                            this.m_spec.m_init_throw_code = this.packCode(this.m_init_throw_code_dir, this.m_init_throw_code_end_dir, this.m_spec.m_init_throw_code, this.m_spec.m_init_throw_read, 3);
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_implements_dir, 0, this.m_implements_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_implements_dir.length;
                            this.m_spec.m_implements_name = this.getName();
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_ignorecase_dir, 0, this.m_ignorecase_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_ignorecase_dir.length;
                            this.m_spec.m_ignorecase = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'l': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_line_dir, 0, this.m_line_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_line_dir.length;
                            this.m_spec.m_count_lines = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'n': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_notunix_dir, 0, this.m_notunix_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_notunix_dir.length;
                            this.m_spec.m_unix = false;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'p': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_public_dir, 0, this.m_public_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_public_dir.length;
                            this.m_spec.m_public = true;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 's': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_state_dir, 0, this.m_state_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_state_dir.length;
                            this.saveStates();
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 't': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_type_dir, 0, this.m_type_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_type_dir.length;
                            this.m_spec.m_type_name = this.getName();
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'u': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_unicode_dir, 0, this.m_unicode_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_unicode_dir.length;
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    case 'y': {
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_yyeof_dir, 0, this.m_yyeof_dir.length - 1) == 0) {
                            this.m_input.m_line_index = this.m_yyeof_dir.length;
                            this.m_spec.m_yyeof = true;
                            break;
                        }
                        if (CUtility.charncmp(this.m_input.m_line, 0, this.m_yylex_throw_code_dir, 0, this.m_yylex_throw_code_dir.length - 1) == 0) {
                            this.m_spec.m_yylex_throw_code = this.packCode(this.m_yylex_throw_code_dir, this.m_yylex_throw_code_end_dir, this.m_spec.m_yylex_throw_code, this.m_spec.m_yylex_throw_read, 4);
                            break;
                        }
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                    default: {
                        CError.parse_error(12, this.m_input.m_line_number);
                        break;
                    }
                }
                continue;
            }
            this.m_input.m_line_index = 0;
            this.saveMacro();
        }
    }

    private void userRules() throws IOException {
        if (!this.m_init_flag) {
            CError.parse_error(10, 0);
        }
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating NFA machine representation.");
        }
        this.m_makeNfa.thompson(this, this.m_spec, this.m_input);
        CUtility.cuassert(11 == this.m_spec.m_current_token);
        if (this.m_spec.m_verbose) {
            System.out.println("Creating DFA transition table.");
        }
        this.m_nfa2dfa.make_dfa(this, this.m_spec);
        if (this.m_spec.m_verbose) {
            System.out.println("Minimizing DFA transition table.");
        }
        this.m_minimize.min_dfa(this.m_spec);
    }

    private void printccl(CSet set) {
        System.out.print(" [");
        int i = 0;
        while (i < this.m_spec.m_dtrans_ncols) {
            if (set.contains(i)) {
                System.out.print(this.interp_int(i));
            }
            ++i;
        }
        System.out.print(']');
    }

    private String plab(CNfa state) {
        if (state == null) {
            return "--";
        }
        int index = this.m_spec.m_nfa_states.indexOf(state);
        return Integer.valueOf(index).toString();
    }

    private String interp_int(int i) {
        switch (i) {
            case 8: {
                return "\\b";
            }
            case 9: {
                return "\\t";
            }
            case 10: {
                return "\\n";
            }
            case 12: {
                return "\\f";
            }
            case 13: {
                return "\\r";
            }
            case 32: {
                return "\\ ";
            }
        }
        return Character.toString((char)i);
    }

    void print_nfa() {
        CNfa nfa;
        System.out.println("--------------------- NFA -----------------------");
        int size = this.m_spec.m_nfa_states.size();
        int elem = 0;
        while (elem < size) {
            nfa = (CNfa)this.m_spec.m_nfa_states.elementAt(elem);
            System.out.print("Nfa state " + this.plab(nfa) + ": ");
            if (nfa.m_next == null) {
                System.out.print("(TERMINAL)");
            } else {
                System.out.print("--> " + this.plab(nfa.m_next));
                System.out.print("--> " + this.plab(nfa.m_next2));
                switch (nfa.m_edge) {
                    case -1: {
                        this.printccl(nfa.m_set);
                        break;
                    }
                    case -3: {
                        System.out.print(" EPSILON ");
                        break;
                    }
                    default: {
                        System.out.print(" " + this.interp_int(nfa.m_edge));
                    }
                }
            }
            if (elem == 0) {
                System.out.print(" (START STATE)");
            }
            if (nfa.m_accept != null) {
                System.out.print(" accepting " + ((nfa.m_anchor & 1) != 0 ? "^" : "") + "<" + new String(nfa.m_accept.m_action, 0, nfa.m_accept.m_action_read) + ">" + ((nfa.m_anchor & 2) != 0 ? "$" : ""));
            }
            System.out.println("");
            ++elem;
        }
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.cuassert(state != null);
            CUtility.cuassert(index != null);
            System.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
            System.out.print("\tStart states of matching rules: ");
            int i = index;
            int vsize = this.m_spec.m_state_rules[i].size();
            int j = 0;
            while (j < vsize) {
                nfa = (CNfa)this.m_spec.m_state_rules[i].elementAt(j);
                System.out.print(String.valueOf(this.m_spec.m_nfa_states.indexOf(nfa)) + " ");
                ++j;
            }
            System.out.println("");
        }
        System.out.println("-------------------- NFA ----------------------");
    }

    JavaLexBitSet getStates() throws IOException {
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        JavaLexBitSet states = null;
        while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
            ++this.m_input.m_line_index;
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                return null;
            }
        }
        if ('<' == this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            states = new JavaLexBitSet();
            while (true) {
                int count_state;
                String name;
                Integer index;
                if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return states;
                }
                block3: while (true) {
                    if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                        do {
                            if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                        } while (!this.m_input.getLine());
                        CError.parse_error(11, this.m_input.m_line_number);
                        return states;
                    }
                    if (',' != this.m_input.m_line[this.m_input.m_line_index]) break;
                    ++this.m_input.m_line_index;
                }
                if ('>' == this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) {
                        this.m_advance_stop = true;
                    }
                    return states;
                }
                int start_state = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index] && '>' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index >= this.m_input.m_line_read) break;
                }
                if ((index = (Integer)this.m_spec.m_states.get(name = new String(this.m_input.m_line, start_state, count_state = this.m_input.m_line_index - start_state))) == null) {
                    System.out.println("Uninitialized State Name: " + name);
                    CError.parse_error(14, this.m_input.m_line_number);
                }
                states.set(index);
            }
        }
        if (this.all_states == null) {
            this.all_states = new JavaLexBitSet();
            int size = this.m_spec.m_states.size();
            int i = 0;
            while (i < size) {
                this.all_states.set(i);
                ++i;
            }
        }
        if (this.m_input.m_line_index < this.m_input.m_line_read) {
            this.m_advance_stop = true;
        }
        return this.all_states;
    }

    private boolean expandMacro() {
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
            CError.parse_error(13, this.m_input.m_line_number);
            return false;
        }
        int start_macro = this.m_input.m_line_index;
        int elem = this.m_input.m_line_index + 1;
        if (elem >= this.m_input.m_line_read) {
            CError.impos("Unfinished macro name");
            return false;
        }
        int start_name = elem;
        while ('}' != this.m_input.m_line[elem]) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.impos("Unfinished macro name at line " + this.m_input.m_line_number);
            return false;
        }
        int count_name = elem - start_name;
        int end_macro = elem;
        if (count_name == 0) {
            CError.impos("Nonexistent macro name");
            return false;
        }
        CUtility.cuassert(count_name > 0);
        String name = new String(this.m_input.m_line, start_name, count_name);
        String def = (String)this.m_spec.m_macros.get(name);
        if (def == null) {
            System.out.println("Error: Undefined macro \"" + name + "\".");
            CError.parse_error(8, this.m_input.m_line_number);
            return false;
        }
        char[] replace = new char[this.m_input.m_line.length];
        int rep_elem = 0;
        while (rep_elem < start_macro) {
            replace[rep_elem] = this.m_input.m_line[rep_elem];
            CUtility.cuassert(rep_elem < replace.length);
            ++rep_elem;
        }
        if (rep_elem >= replace.length) {
            replace = CUtility.doubleSize(replace);
        }
        int def_elem = 0;
        while (def_elem < def.length()) {
            replace[rep_elem] = def.charAt(def_elem);
            if (++rep_elem >= replace.length) {
                replace = CUtility.doubleSize(replace);
            }
            ++def_elem;
        }
        if (rep_elem >= replace.length) {
            replace = CUtility.doubleSize(replace);
        }
        elem = end_macro + 1;
        while (elem < this.m_input.m_line_read) {
            replace[rep_elem] = this.m_input.m_line[elem];
            if (++rep_elem >= replace.length) {
                replace = CUtility.doubleSize(replace);
            }
            ++elem;
        }
        this.m_input.m_line = replace;
        this.m_input.m_line_read = rep_elem;
        return true;
    }

    private void saveMacro() {
        int count_def;
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        int elem = 0;
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            return;
        }
        int start_name = elem;
        while (!CUtility.isspace(this.m_input.m_line[elem]) && '=' != this.m_input.m_line[elem]) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int count_name = elem - start_name;
        if (count_name == 0) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        if ('=' == this.m_input.m_line[elem] && ++elem >= this.m_input.m_line_read) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        while (CUtility.isspace(this.m_input.m_line[elem])) {
            if (++elem < this.m_input.m_line_read) continue;
            CError.parse_error(15, this.m_input.m_line_number);
        }
        int start_def = elem;
        boolean in_quote = false;
        boolean in_ccl = false;
        boolean saw_escape = false;
        while (!CUtility.isspace(this.m_input.m_line[elem]) || in_quote || in_ccl || saw_escape) {
            if ('\"' == this.m_input.m_line[elem] && !saw_escape) {
                in_quote = !in_quote;
            }
            if (!(saw_escape = '\\' == this.m_input.m_line[elem] && !saw_escape) && !in_quote) {
                if ('[' == this.m_input.m_line[elem] && !in_ccl) {
                    in_ccl = true;
                }
                if (']' == this.m_input.m_line[elem] && in_ccl) {
                    in_ccl = false;
                }
            }
            if (++elem >= this.m_input.m_line_read) break;
        }
        if ((count_def = elem - start_def) == 0) {
            CError.parse_error(15, this.m_input.m_line_number);
        }
        CUtility.cuassert(count_def > 0);
        CUtility.cuassert(count_name > 0);
        CUtility.cuassert(this.m_spec.m_macros != null);
        this.m_spec.m_macros.put(new String(this.m_input.m_line, start_name, count_name), new String(this.m_input.m_line, start_def, count_def));
    }

    /*
     * Unable to fully structure code
     */
    private void saveStates() {
        CUtility.cuassert(this != null);
        CUtility.cuassert(this.m_outstream != null);
        CUtility.cuassert(this.m_input != null);
        CUtility.cuassert(this.m_tokens != null);
        CUtility.cuassert(this.m_spec != null);
        if (this.m_input.m_eof_reached) {
            return;
        }
        CUtility.cuassert('%' == this.m_input.m_line[0]);
        CUtility.cuassert('s' == this.m_input.m_line[1]);
        CUtility.cuassert(this.m_input.m_line_index <= this.m_input.m_line_read);
        CUtility.cuassert(this.m_input.m_line_index >= 0);
        CUtility.cuassert(this.m_input.m_line_read >= 0);
        if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl32
        return;
        {
            ++this.m_input.m_line_index;
            if (this.m_input.m_line_index >= this.m_input.m_line_read) {
                return;
            }
            do {
                if (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) continue block0;
                start_state = this.m_input.m_line_index;
                while (!CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index]) && ',' != this.m_input.m_line[this.m_input.m_line_index]) {
                    ++this.m_input.m_line_index;
                    if (this.m_input.m_line_index >= this.m_input.m_line_read) break;
                }
                count_state = this.m_input.m_line_index - start_state;
                this.m_spec.m_states.put(new String(this.m_input.m_line, start_state, count_state), this.m_spec.m_states.size());
                if (',' != this.m_input.m_line[this.m_input.m_line_index]) continue;
                ++this.m_input.m_line_index;
                if (this.m_input.m_line_index < this.m_input.m_line_read) continue;
                return;
lbl32:
                // 3 sources

            } while (this.m_input.m_line_index < this.m_input.m_line_read);
        }
    }

    private char expandEscape() {
        char r;
        CUtility.cuassert(this.m_input.m_line_index < this.m_input.m_line_read);
        CUtility.cuassert(this.m_input.m_line_read > 0);
        CUtility.cuassert(this.m_input.m_line_index >= 0);
        if ('\\' != this.m_input.m_line[this.m_input.m_line_index]) {
            ++this.m_input.m_line_index;
            return this.m_input.m_line[this.m_input.m_line_index - 1];
        }
        ++this.m_input.m_line_index;
        switch (CUtility.toupper(this.m_input.m_line[this.m_input.m_line_index])) {
            case 'B': {
                ++this.m_input.m_line_index;
                return '\b';
            }
            case 'T': {
                ++this.m_input.m_line_index;
                return '\t';
            }
            case 'N': {
                ++this.m_input.m_line_index;
                return '\n';
            }
            case 'F': {
                ++this.m_input.m_line_index;
                return '\f';
            }
            case 'R': {
                ++this.m_input.m_line_index;
                return '\r';
            }
            case '^': {
                ++this.m_input.m_line_index;
                char r2 = (char)(CUtility.toupper(this.m_input.m_line[this.m_input.m_line_index]) - 64);
                ++this.m_input.m_line_index;
                return r2;
            }
            case 'X': {
                ++this.m_input.m_line_index;
                char r3 = '\u0000';
                if (CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index])) {
                    r3 = CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index]);
                    ++this.m_input.m_line_index;
                }
                if (CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index])) {
                    r3 = (char)(r3 << 4);
                    r3 = (char)(r3 | CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index]));
                    ++this.m_input.m_line_index;
                }
                if (CUtility.ishexdigit(this.m_input.m_line[this.m_input.m_line_index])) {
                    r3 = (char)(r3 << 4);
                    r3 = (char)(r3 | CUtility.hex2bin(this.m_input.m_line[this.m_input.m_line_index]));
                    ++this.m_input.m_line_index;
                }
                return r3;
            }
        }
        if (!CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
            r = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        } else {
            r = CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index]);
            ++this.m_input.m_line_index;
            if (CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
                r = (char)(r << 3);
                r = (char)(r | CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index]));
                ++this.m_input.m_line_index;
            }
            if (CUtility.isoctdigit(this.m_input.m_line[this.m_input.m_line_index])) {
                r = (char)(r << 3);
                r = (char)(r | CUtility.oct2bin(this.m_input.m_line[this.m_input.m_line_index]));
                ++this.m_input.m_line_index;
            }
        }
        return r;
    }

    CAccept packAccept() throws IOException {
        int action_index;
        char[] action;
        block21: {
            action = new char[1024];
            action_index = 0;
            CUtility.cuassert(this != null);
            CUtility.cuassert(this.m_outstream != null);
            CUtility.cuassert(this.m_input != null);
            CUtility.cuassert(this.m_tokens != null);
            CUtility.cuassert(this.m_spec != null);
            while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (!this.m_input.getLine()) continue;
                CError.parse_error(11, this.m_input.m_line_number);
                return null;
            }
            while (CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                ++this.m_input.m_line_index;
                while (this.m_input.m_line_index >= this.m_input.m_line_read) {
                    if (!this.m_input.getLine()) continue;
                    CError.parse_error(11, this.m_input.m_line_number);
                    return null;
                }
            }
            if ('{' != this.m_input.m_line[this.m_input.m_line_index]) {
                CError.parse_error(17, this.m_input.m_line_number);
            }
            int brackets = 0;
            boolean instarcomment = false;
            boolean inslashcomment = false;
            boolean inquotes = false;
            boolean slashed = false;
            boolean escaped = false;
            block3: while (true) {
                action[action_index] = this.m_input.m_line[this.m_input.m_line_index];
                if (inquotes && escaped) {
                    escaped = false;
                } else if (inquotes && '\\' == this.m_input.m_line[this.m_input.m_line_index]) {
                    escaped = true;
                } else if ('\"' == this.m_input.m_line[this.m_input.m_line_index]) {
                    boolean bl = inquotes = !inquotes;
                }
                if (instarcomment) {
                    if (slashed && '/' == this.m_input.m_line[this.m_input.m_line_index]) {
                        slashed = false;
                        instarcomment = false;
                    } else {
                        slashed = '*' == this.m_input.m_line[this.m_input.m_line_index];
                    }
                } else if (!inslashcomment) {
                    inslashcomment = slashed && '/' == this.m_input.m_line[this.m_input.m_line_index];
                    instarcomment = slashed && '*' == this.m_input.m_line[this.m_input.m_line_index];
                    boolean bl = slashed = '/' == this.m_input.m_line[this.m_input.m_line_index];
                }
                if (!(inquotes || instarcomment || inslashcomment)) {
                    if ('{' == this.m_input.m_line[this.m_input.m_line_index]) {
                        ++brackets;
                    } else if ('}' == this.m_input.m_line[this.m_input.m_line_index] && --brackets == 0) {
                        ++this.m_input.m_line_index;
                        break block21;
                    }
                }
                if (++action_index >= action.length) {
                    action = CUtility.doubleSize(action);
                }
                ++this.m_input.m_line_index;
                do {
                    if (this.m_input.m_line_index < this.m_input.m_line_read) continue block3;
                    slashed = false;
                    inslashcomment = false;
                    if (!inquotes) continue;
                    CError.parse_error(6, this.m_input.m_line_number);
                    inquotes = false;
                } while (!this.m_input.getLine());
                break;
            }
            CError.parse_error(16, this.m_input.m_line_number);
            return null;
        }
        CAccept accept = new CAccept(action, ++action_index, this.m_input.m_line_number);
        CUtility.cuassert(accept != null);
        return accept;
    }

    /*
     * Unable to fully structure code
     */
    int advance() throws IOException {
        block19: {
            saw_escape = false;
            if (this.m_input.m_eof_reached) {
                this.m_spec.m_current_token = 11;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (1 == this.m_spec.m_current_token || this.m_input.m_line_index >= this.m_input.m_line_read) {
                if (this.m_spec.m_in_quote) {
                    CError.parse_error(16, this.m_input.m_line_number);
                }
                do {
                    if (!this.m_advance_stop || this.m_input.m_line_index >= this.m_input.m_line_read) {
                        if (this.m_input.getLine()) {
                            this.m_spec.m_current_token = 11;
                            this.m_spec.m_lexeme = '\u0000';
                            return this.m_spec.m_current_token;
                        }
                        this.m_input.m_line_index = 0;
                    } else {
                        this.m_advance_stop = false;
                    }
                    while (this.m_input.m_line_index < this.m_input.m_line_read && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                        ++this.m_input.m_line_index;
                    }
                } while (this.m_input.m_line_index >= this.m_input.m_line_read);
            }
            CUtility.cuassert(this.m_input.m_line_index <= this.m_input.m_line_read);
            do lbl-1000:
            // 3 sources

            {
                block20: {
                    if (this.m_spec.m_in_quote || '{' != this.m_input.m_line[this.m_input.m_line_index]) break block20;
                    if (!this.expandMacro()) break block19;
                    if (this.m_input.m_line_index < this.m_input.m_line_read) ** GOTO lbl-1000
                    this.m_spec.m_current_token = 1;
                    this.m_spec.m_lexeme = '\u0000';
                    return this.m_spec.m_current_token;
                }
                if ('\"' != this.m_input.m_line[this.m_input.m_line_index]) break block19;
                this.m_spec.m_in_quote = this.m_spec.m_in_quote == false;
                ++this.m_input.m_line_index;
            } while (this.m_input.m_line_index < this.m_input.m_line_read);
            this.m_spec.m_current_token = 1;
            this.m_spec.m_lexeme = '\u0000';
            return this.m_spec.m_current_token;
        }
        if (this.m_input.m_line_index > this.m_input.m_line_read) {
            System.out.println("m_input.m_line_index = " + this.m_input.m_line_index);
            System.out.println("m_input.m_line_read = " + this.m_input.m_line_read);
            CUtility.cuassert(this.m_input.m_line_index <= this.m_input.m_line_read);
        }
        saw_escape = '\\' == this.m_input.m_line[this.m_input.m_line_index];
        if (!this.m_spec.m_in_quote) {
            if (!this.m_spec.m_in_ccl && CUtility.isspace(this.m_input.m_line[this.m_input.m_line_index])) {
                this.m_spec.m_current_token = 1;
                this.m_spec.m_lexeme = '\u0000';
                return this.m_spec.m_current_token;
            }
            if (saw_escape) {
                this.m_spec.m_lexeme = this.expandEscape();
            } else {
                this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
                ++this.m_input.m_line_index;
            }
        } else if (saw_escape && this.m_input.m_line_index + 1 < this.m_input.m_line_read && '\"' == this.m_input.m_line[this.m_input.m_line_index + 1]) {
            this.m_spec.m_lexeme = (char)34;
            this.m_input.m_line_index += 2;
        } else {
            this.m_spec.m_lexeme = this.m_input.m_line[this.m_input.m_line_index];
            ++this.m_input.m_line_index;
        }
        code = (Integer)this.m_tokens.get(Character.valueOf(this.m_spec.m_lexeme));
        this.m_spec.m_current_token = this.m_spec.m_in_quote != false || saw_escape != false ? 12 : (code == null ? 12 : code);
        if (6 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = true;
        }
        if (5 == this.m_spec.m_current_token) {
            this.m_spec.m_in_ccl = false;
        }
        return this.m_spec.m_current_token;
    }

    private void details() {
        System.out.println("\n\t** Macros **");
        Enumeration names = this.m_spec.m_macros.keys();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String def = (String)this.m_spec.m_macros.get(name);
            CUtility.cuassert(name != null);
            CUtility.cuassert(def != null);
            System.out.println("Macro name \"" + name + "\" has definition \"" + def + "\".");
        }
        System.out.println("\n\t** States **");
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.cuassert(state != null);
            CUtility.cuassert(index != null);
            System.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
        }
        System.out.println("\n\t** Character Counting **");
        if (!this.m_spec.m_count_chars) {
            System.out.println("Character counting is off.");
        } else {
            CUtility.cuassert(this.m_spec.m_count_lines);
            System.out.println("Character counting is on.");
        }
        System.out.println("\n\t** Line Counting **");
        if (!this.m_spec.m_count_lines) {
            System.out.println("Line counting is off.");
        } else {
            CUtility.cuassert(this.m_spec.m_count_lines);
            System.out.println("Line counting is on.");
        }
        System.out.println("\n\t** Operating System Specificity **");
        if (!this.m_spec.m_unix) {
            System.out.println("Not generating UNIX-specific code.");
            System.out.println("(This means that \"\\r\\n\" is a newline, rather than \"\\n\".)");
        } else {
            System.out.println("Generating UNIX-specific code.");
            System.out.println("(This means that \"\\n\" is a newline, rather than \"\\r\\n\".)");
        }
        System.out.println("\n\t** Java CUP Compatibility **");
        if (!this.m_spec.m_cup_compatible) {
            System.out.println("Generating CUP compatible code.");
            System.out.println("(No current results.)");
        } else {
            System.out.println("Not generating CUP compatible code.");
            System.out.println("(No current results.)");
        }
        if (this.m_spec.m_dtrans_vector != null) {
            System.out.println("\n\t** DFA transition table **");
        }
    }

    void print_set(Vector nfa_set) {
        int size = nfa_set.size();
        if (size == 0) {
            System.out.print("empty ");
        }
        int elem = 0;
        while (elem < size) {
            CNfa nfa = (CNfa)nfa_set.elementAt(elem);
            System.out.print(String.valueOf(nfa.m_label) + " ");
            ++elem;
        }
    }

    private void print_header() {
        int i;
        int chars_printed = 0;
        System.out.println("/*---------------------- DFA -----------------------");
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            Integer index = (Integer)this.m_spec.m_states.get(state);
            CUtility.cuassert(state != null);
            CUtility.cuassert(index != null);
            System.out.println("State \"" + state + "\" has identifying index " + index.toString() + ".");
            i = index;
            if (-1 != this.m_spec.m_state_dtrans[i]) {
                System.out.println("\tStart index in transition table: " + this.m_spec.m_state_dtrans[i]);
                continue;
            }
            System.out.println("\tNo associated transition states.");
        }
        i = 0;
        while (i < this.m_spec.m_dtrans_vector.size()) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(i);
            if (this.m_spec.m_accept_vector == null && this.m_spec.m_anchor_array == null) {
                if (dtrans.m_accept == null) {
                    System.out.print(" * State " + i + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + i + " [accepting, line " + dtrans.m_accept.m_line_number + " <" + new String(dtrans.m_accept.m_action, 0, dtrans.m_accept.m_action_read) + ">]");
                    if (dtrans.m_anchor != 0) {
                        System.out.print(" Anchor: " + ((dtrans.m_anchor & 1) != 0 ? "start " : "") + ((dtrans.m_anchor & 2) != 0 ? "end " : ""));
                    }
                }
            } else {
                CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(i);
                if (accept == null) {
                    System.out.print(" * State " + i + " [nonaccepting]");
                } else {
                    System.out.print(" * State " + i + " [accepting, line " + accept.m_line_number + " <" + new String(accept.m_action, 0, accept.m_action_read) + ">]");
                    if (this.m_spec.m_anchor_array[i] != 0) {
                        System.out.print(" Anchor: " + ((this.m_spec.m_anchor_array[i] & 1) != 0 ? "start " : "") + ((this.m_spec.m_anchor_array[i] & 2) != 0 ? "end " : ""));
                    }
                }
            }
            int last_transition = -1;
            int j = 0;
            while (j < this.m_spec.m_dtrans_ncols) {
                if (-1 != dtrans.m_dtrans[j]) {
                    if (last_transition != dtrans.m_dtrans[j]) {
                        System.out.print("\n *    goto " + dtrans.m_dtrans[j] + " on ");
                        chars_printed = 0;
                    }
                    String str = this.interp_int(j);
                    System.out.print(str);
                    if (56 < (chars_printed += str.length())) {
                        System.out.print("\n *             ");
                        chars_printed = 0;
                    }
                    last_transition = dtrans.m_dtrans[j];
                }
                ++j;
            }
            System.out.println("");
            ++i;
        }
        System.out.println(" */\n");
    }
}

