/*
 * Decompiled with CFR 0.152.
 */
package com.JLex;

import com.JLex.CAccept;
import com.JLex.CDTrans;
import com.JLex.CSpec;
import com.JLex.CUtility;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

class CEmit {
    private CSpec m_spec;
    private DataOutputStream m_outstream;
    private static final boolean NOT_EDBG = false;

    CEmit() {
        this.reset();
    }

    private void reset() {
        this.m_spec = null;
        this.m_outstream = null;
    }

    private void set(CSpec spec, OutputStream outstream) {
        CUtility.cuassert(spec != null);
        CUtility.cuassert(outstream != null);
        this.m_spec = spec;
        this.m_outstream = new DataOutputStream(outstream);
    }

    private void print_details() {
        System.out.println("---------------------- Transition Table ----------------------");
        int i = 0;
        while (i < this.m_spec.m_row_map.length) {
            System.out.print("State " + i);
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(i);
            if (accept == null) {
                System.out.println(" [nonaccepting]");
            } else {
                System.out.println(" [accepting, line " + accept.m_line_number + " <" + new String(accept.m_action, 0, accept.m_action_read) + ">]");
            }
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(this.m_spec.m_row_map[i]);
            boolean tr = false;
            int state = dtrans.m_dtrans[this.m_spec.m_col_map[0]];
            if (-1 != state) {
                tr = true;
                System.out.print("\tgoto " + state + " on [" + '\u0000');
            }
            int j = 1;
            while (j < this.m_spec.m_dtrans_ncols) {
                int next = dtrans.m_dtrans[this.m_spec.m_col_map[j]];
                if (state == next) {
                    if (-1 != state) {
                        System.out.print((char)j);
                    }
                } else {
                    state = next;
                    if (tr) {
                        System.out.println("]");
                        tr = false;
                    }
                    if (-1 != state) {
                        tr = true;
                        System.out.print("\tgoto " + state + " on [" + (char)j);
                    }
                }
                ++j;
            }
            if (tr) {
                System.out.println("]");
            }
            ++i;
        }
        System.out.println("---------------------- Transition Table ----------------------");
    }

    void emit(CSpec spec, OutputStream outstream) throws IOException {
        this.set(spec, outstream);
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.emit_header();
        this.emit_construct();
        this.emit_helpers();
        this.emit_driver();
        this.emit_footer();
        this.reset();
    }

    private void emit_construct() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.m_outstream.writeBytes("\tprivate final int YY_BUFFER_SIZE = 512;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_F = -1;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_NO_STATE = -1;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_NOT_ACCEPT = 0;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_START = 1;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_END = 2;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_NO_ANCHOR = 4;\n");
        this.m_outstream.writeBytes("\tprivate final char YY_EOF = '\\uFFFF';\n");
        if (this.m_spec.m_integer_type || this.m_spec.m_yyeof) {
            this.m_outstream.writeBytes("\tpublic final int YYEOF = -1;\n");
        }
        if (this.m_spec.m_class_code != null) {
            this.m_outstream.writeBytes(new String(this.m_spec.m_class_code, 0, this.m_spec.m_class_read));
        }
        this.m_outstream.writeBytes("\tprivate java.io.BufferedReader yy_reader;\n");
        this.m_outstream.writeBytes("\tprivate int yy_buffer_index;\n");
        this.m_outstream.writeBytes("\tprivate int yy_buffer_read;\n");
        this.m_outstream.writeBytes("\tprivate int yy_buffer_start;\n");
        this.m_outstream.writeBytes("\tprivate int yy_buffer_end;\n");
        this.m_outstream.writeBytes("\tprivate char yy_buffer[];\n");
        if (this.m_spec.m_count_chars) {
            this.m_outstream.writeBytes("\tprivate int yychar;\n");
        }
        if (this.m_spec.m_count_lines) {
            this.m_outstream.writeBytes("\tprivate int yyline;\n");
        }
        this.m_outstream.writeBytes("\tprivate int yy_lexical_state;\n");
        this.m_outstream.writeBytes("\n");
        this.m_outstream.writeBytes("\t");
        if (this.m_spec.m_public) {
            this.m_outstream.writeBytes("public ");
        }
        this.m_outstream.writeBytes(new String(this.m_spec.m_class_name));
        this.m_outstream.writeBytes(" (java.io.Reader reader)");
        if (this.m_spec.m_init_throw_code != null) {
            this.m_outstream.writeBytes("\n");
            this.m_outstream.writeBytes("\t\tthrows ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.writeBytes("\n\t\t{\n");
        } else {
            this.m_outstream.writeBytes(" {\n");
        }
        this.m_outstream.writeBytes("\t\tthis ();\n");
        this.m_outstream.writeBytes("\t\tif (null == reader) {\n");
        this.m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input stream initializer.\"));\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t\tyy_reader = new java.io.BufferedReader(reader);\n");
        this.m_outstream.writeBytes("\t}\n\n");
        this.m_outstream.writeBytes("\t");
        if (this.m_spec.m_public) {
            this.m_outstream.writeBytes("public ");
        }
        this.m_outstream.writeBytes(new String(this.m_spec.m_class_name));
        this.m_outstream.writeBytes(" (java.io.InputStream instream)");
        if (this.m_spec.m_init_throw_code != null) {
            this.m_outstream.writeBytes("\n");
            this.m_outstream.writeBytes("\t\tthrows ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.writeBytes("\n\t\t{\n");
        } else {
            this.m_outstream.writeBytes(" {\n");
        }
        this.m_outstream.writeBytes("\t\tthis ();\n");
        this.m_outstream.writeBytes("\t\tif (null == instream) {\n");
        this.m_outstream.writeBytes("\t\t\tthrow (new Error(\"Error: Bad input stream initializer.\"));\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t\tyy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));\n");
        this.m_outstream.writeBytes("\t}\n\n");
        this.m_outstream.writeBytes("\tprivate ");
        this.m_outstream.writeBytes(new String(this.m_spec.m_class_name));
        this.m_outstream.writeBytes(" ()");
        if (this.m_spec.m_init_throw_code != null) {
            this.m_outstream.writeBytes("\n");
            this.m_outstream.writeBytes("\t\tthrows ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_init_throw_code, 0, this.m_spec.m_init_throw_read));
            this.m_outstream.writeBytes("\n\t\t{\n");
        } else {
            this.m_outstream.writeBytes(" {\n");
        }
        this.m_outstream.writeBytes("\t\tyy_buffer = new char[YY_BUFFER_SIZE];\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_read = 0;\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_index = 0;\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_start = 0;\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_end = 0;\n");
        if (this.m_spec.m_count_chars) {
            this.m_outstream.writeBytes("\t\tyychar = 0;\n");
        }
        if (this.m_spec.m_count_lines) {
            this.m_outstream.writeBytes("\t\tyyline = 0;\n");
        }
        this.m_outstream.writeBytes("\t\tyy_lexical_state = YYINITIAL;\n");
        if (this.m_spec.m_init_code != null) {
            this.m_outstream.writeBytes(new String(this.m_spec.m_init_code, 0, this.m_spec.m_init_read));
        }
        this.m_outstream.writeBytes("\t}\n\n");
    }

    private void emit_states() throws IOException {
        Enumeration states = this.m_spec.m_states.keys();
        while (states.hasMoreElements()) {
            String state = (String)states.nextElement();
            CUtility.cuassert(state != null);
            this.m_outstream.writeBytes("\tprivate final int " + state + " = " + this.m_spec.m_states.get(state).toString() + ";\n");
        }
        this.m_outstream.writeBytes("\tprivate final int yy_state_dtrans[] = {\n");
        int index = 0;
        while (index < this.m_spec.m_state_dtrans.length) {
            this.m_outstream.writeBytes("\t\t" + this.m_spec.m_state_dtrans[index]);
            if (index < this.m_spec.m_state_dtrans.length - 1) {
                this.m_outstream.writeBytes(",\n");
            } else {
                this.m_outstream.writeBytes("\n");
            }
            ++index;
        }
        this.m_outstream.writeBytes("\t};\n");
    }

    private void emit_helpers() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.m_outstream.writeBytes("\tprivate boolean yy_eof_done = false;\n");
        if (this.m_spec.m_eof_code != null) {
            this.m_outstream.writeBytes("\tprivate void yy_do_eof ()");
            if (this.m_spec.m_eof_throw_code != null) {
                this.m_outstream.writeBytes("\n");
                this.m_outstream.writeBytes("\t\tthrows ");
                this.m_outstream.writeBytes(new String(this.m_spec.m_eof_throw_code, 0, this.m_spec.m_eof_throw_read));
                this.m_outstream.writeBytes("\n\t\t{\n");
            } else {
                this.m_outstream.writeBytes(" {\n");
            }
            this.m_outstream.writeBytes("\t\tif (false == yy_eof_done) {\n");
            this.m_outstream.writeBytes(new String(this.m_spec.m_eof_code, 0, this.m_spec.m_eof_read));
            this.m_outstream.writeBytes("\t\t}\n");
            this.m_outstream.writeBytes("\t\tyy_eof_done = true;\n");
            this.m_outstream.writeBytes("\t}\n");
        }
        this.emit_states();
        this.m_outstream.writeBytes("\tprivate void yybegin (int state) {\n");
        this.m_outstream.writeBytes("\t\tyy_lexical_state = state;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate char yy_advance ()\n");
        this.m_outstream.writeBytes("\t\tthrows java.io.IOException {\n");
        this.m_outstream.writeBytes("\t\tint next_read;\n");
        this.m_outstream.writeBytes("\t\tint i;\n");
        this.m_outstream.writeBytes("\t\tint j;\n");
        this.m_outstream.writeBytes("\n");
        this.m_outstream.writeBytes("\t\tif (yy_buffer_index < yy_buffer_read) {\n");
        this.m_outstream.writeBytes("\t\t\treturn yy_buffer[yy_buffer_index++];\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\n");
        this.m_outstream.writeBytes("\t\tif (0 != yy_buffer_start) {\n");
        this.m_outstream.writeBytes("\t\t\ti = yy_buffer_start;\n");
        this.m_outstream.writeBytes("\t\t\tj = 0;\n");
        this.m_outstream.writeBytes("\t\t\twhile (i < yy_buffer_read) {\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_buffer[j] = yy_buffer[i];\n");
        this.m_outstream.writeBytes("\t\t\t\t++i;\n");
        this.m_outstream.writeBytes("\t\t\t\t++j;\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_end = yy_buffer_end - yy_buffer_start;\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_start = 0;\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_read = j;\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_index = j;\n");
        this.m_outstream.writeBytes("\t\t\tnext_read = yy_reader.read(yy_buffer,\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        this.m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        this.m_outstream.writeBytes("\t\t\t\treturn YY_EOF;\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\n");
        this.m_outstream.writeBytes("\t\twhile (yy_buffer_index >= yy_buffer_read) {\n");
        this.m_outstream.writeBytes("\t\t\tif (yy_buffer_index >= yy_buffer.length) {\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_buffer = yy_double(yy_buffer);\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\tnext_read = yy_reader.read(yy_buffer,\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_buffer_read,\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_buffer.length - yy_buffer_read);\n");
        this.m_outstream.writeBytes("\t\t\tif (-1 == next_read) {\n");
        this.m_outstream.writeBytes("\t\t\t\treturn YY_EOF;\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_read = yy_buffer_read + next_read;\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t\treturn yy_buffer[yy_buffer_index++];\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate void yy_move_start () {\n");
        if (this.m_spec.m_count_lines) {
            if (this.m_spec.m_unix) {
                this.m_outstream.writeBytes("\t\tif ((byte) '\\n' == yy_buffer[yy_buffer_start]) {\n");
            } else {
                this.m_outstream.writeBytes("\t\tif ((byte) '\\n' == yy_buffer[yy_buffer_start]\n");
                this.m_outstream.writeBytes("\t\t\t|| (byte) '\\r' == yy_buffer[yy_buffer_start]) {\n");
            }
            this.m_outstream.writeBytes("\t\t\t++yyline;\n");
            this.m_outstream.writeBytes("\t\t}\n");
        }
        if (this.m_spec.m_count_chars) {
            this.m_outstream.writeBytes("\t\t++yychar;\n");
        }
        this.m_outstream.writeBytes("\t\t++yy_buffer_start;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate void yy_pushback () {\n");
        this.m_outstream.writeBytes("\t\t--yy_buffer_end;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate void yy_mark_start () {\n");
        if (this.m_spec.m_count_lines || this.m_spec.m_count_chars) {
            if (this.m_spec.m_count_lines) {
                this.m_outstream.writeBytes("\t\tint i;\n");
                this.m_outstream.writeBytes("\t\tfor (i = yy_buffer_start; i < yy_buffer_index; ++i) {\n");
                if (this.m_spec.m_unix) {
                    this.m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i]) {\n");
                } else {
                    this.m_outstream.writeBytes("\t\t\tif ((byte) '\\n' == yy_buffer[i] || (byte) '\\r' == yy_buffer[i]) {\n");
                }
                this.m_outstream.writeBytes("\t\t\t\t++yyline;\n");
                this.m_outstream.writeBytes("\t\t\t}\n");
                this.m_outstream.writeBytes("\t\t}\n");
            }
            if (this.m_spec.m_count_chars) {
                this.m_outstream.writeBytes("\t\tyychar = yychar\n");
                this.m_outstream.writeBytes("\t\t\t+ yy_buffer_index - yy_buffer_start;\n");
            }
        }
        this.m_outstream.writeBytes("\t\tyy_buffer_start = yy_buffer_index;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate void yy_mark_end () {\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_end = yy_buffer_index;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate void yy_to_mark () {\n");
        this.m_outstream.writeBytes("\t\tyy_buffer_index = yy_buffer_end;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate java.lang.String yytext () {\n");
        this.m_outstream.writeBytes("\t\treturn (new java.lang.String(yy_buffer,\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_start,\n");
        this.m_outstream.writeBytes("\t\t\tyy_buffer_end - yy_buffer_start));\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate int yylength () {\n");
        this.m_outstream.writeBytes("\t\treturn yy_buffer_end - yy_buffer_start;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate char[] yy_double (char buf[]) {\n");
        this.m_outstream.writeBytes("\t\tint i;\n\t\tchar newbuf[];\n");
        this.m_outstream.writeBytes("\t\tnewbuf = new char[2*buf.length];\n");
        this.m_outstream.writeBytes("\t\tfor (i = 0; i < buf.length; ++i) {\n");
        this.m_outstream.writeBytes("\t\t\tnewbuf[i] = buf[i];\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t\treturn newbuf;\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("\tprivate final int YY_E_INTERNAL = 0;\n");
        this.m_outstream.writeBytes("\tprivate final int YY_E_MATCH = 1;\n");
        this.m_outstream.writeBytes("\tprivate java.lang.String yy_error_string[] = {\n");
        this.m_outstream.writeBytes("\t\t\"Error: Internal error.\\n\",\n");
        this.m_outstream.writeBytes("\t\t\"Error: Unmatched input.\\n\"\n");
        this.m_outstream.writeBytes("\t};\n");
        this.m_outstream.writeBytes("\tprivate void yy_error (int code,boolean fatal) {\n");
        this.m_outstream.writeBytes("\t\tjava.lang.System.out.print(yy_error_string[code]);\n");
        this.m_outstream.writeBytes("\t\tjava.lang.System.out.flush();\n");
        this.m_outstream.writeBytes("\t\tif (fatal) {\n");
        this.m_outstream.writeBytes("\t\t\tthrow new Error(\"Fatal Error.\\n\");\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t}\n");
        this.m_outstream.writeBytes("private int [][] unpackFromString(int size1, int size2, String st)\n");
        this.m_outstream.writeBytes("    {\n");
        this.m_outstream.writeBytes("      int colonIndex = -1;\n");
        this.m_outstream.writeBytes("      String lengthString;\n");
        this.m_outstream.writeBytes("      int sequenceLength = 0;\n");
        this.m_outstream.writeBytes("      int sequenceInteger = 0;\n");
        this.m_outstream.writeBytes("      int commaIndex;\n");
        this.m_outstream.writeBytes("      String workString;\n");
        this.m_outstream.writeBytes("      int res[][] = new int[size1][size2];\n");
        this.m_outstream.writeBytes("      for (int i= 0; i < size1; i++)\n");
        this.m_outstream.writeBytes("        for (int j= 0; j < size2; j++)\n");
        this.m_outstream.writeBytes("          {\n");
        this.m_outstream.writeBytes("            if (sequenceLength == 0) \n");
        this.m_outstream.writeBytes("              {        \n");
        this.m_outstream.writeBytes("                commaIndex = st.indexOf(',');\n");
        this.m_outstream.writeBytes("                if (commaIndex == -1)\n");
        this.m_outstream.writeBytes("                  workString = st;\n");
        this.m_outstream.writeBytes("                else\n");
        this.m_outstream.writeBytes("                  workString = st.substring(0, commaIndex);\n");
        this.m_outstream.writeBytes("                st = st.substring(commaIndex+1);\n");
        this.m_outstream.writeBytes("                colonIndex = workString.indexOf(':');\n");
        this.m_outstream.writeBytes("                if (colonIndex == -1)\n");
        this.m_outstream.writeBytes("                  {\n");
        this.m_outstream.writeBytes("                    res[i][j] = Integer.parseInt(workString);\n");
        this.m_outstream.writeBytes("                  }\n");
        this.m_outstream.writeBytes("                else \n");
        this.m_outstream.writeBytes("                  {\n");
        this.m_outstream.writeBytes("                    lengthString = workString.substring(colonIndex+1);  \n");
        this.m_outstream.writeBytes("                    sequenceLength = Integer.parseInt(lengthString);\n");
        this.m_outstream.writeBytes("                    workString = workString.substring(0,colonIndex);\n");
        this.m_outstream.writeBytes("                    sequenceInteger = Integer.parseInt(workString);\n");
        this.m_outstream.writeBytes("                    res[i][j] = sequenceInteger;\n");
        this.m_outstream.writeBytes("                    sequenceLength--;\n");
        this.m_outstream.writeBytes("                  }\n");
        this.m_outstream.writeBytes("              }\n");
        this.m_outstream.writeBytes("            else \n");
        this.m_outstream.writeBytes("              {\n");
        this.m_outstream.writeBytes("                res[i][j] = sequenceInteger;\n");
        this.m_outstream.writeBytes("                sequenceLength--;\n");
        this.m_outstream.writeBytes("              }\n");
        this.m_outstream.writeBytes("          }\n");
        this.m_outstream.writeBytes("      return res;\n");
        this.m_outstream.writeBytes("    }\n");
    }

    private void emit_header() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.m_outstream.writeBytes("\n\n");
        if (this.m_spec.m_public) {
            this.m_outstream.writeBytes("public ");
        }
        this.m_outstream.writeBytes("class ");
        this.m_outstream.writeBytes(new String(this.m_spec.m_class_name, 0, this.m_spec.m_class_name.length));
        if (this.m_spec.m_implements_name.length > 0) {
            this.m_outstream.writeBytes(" implements ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_implements_name, 0, this.m_spec.m_implements_name.length));
        }
        this.m_outstream.writeBytes(" {\n");
    }

    private void emit_table() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.m_outstream.writeBytes("\tprivate int yy_acpt[] = {\n");
        int size = this.m_spec.m_accept_vector.size();
        int elem = 0;
        while (elem < size) {
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(elem);
            if (accept != null) {
                boolean is_end;
                boolean is_start = (this.m_spec.m_anchor_array[elem] & 1) != 0;
                boolean bl = is_end = (this.m_spec.m_anchor_array[elem] & 2) != 0;
                if (is_start && is_end) {
                    this.m_outstream.writeBytes("\t\tYY_START | YY_END");
                } else if (is_start) {
                    this.m_outstream.writeBytes("\t\tYY_START");
                } else if (is_end) {
                    this.m_outstream.writeBytes("\t\tYY_END");
                } else {
                    this.m_outstream.writeBytes("\t\tYY_NO_ANCHOR");
                }
            } else {
                this.m_outstream.writeBytes("\t\tYY_NOT_ACCEPT");
            }
            if (elem < size - 1) {
                this.m_outstream.writeBytes(",");
            }
            this.m_outstream.writeBytes("\n");
            ++elem;
        }
        this.m_outstream.writeBytes("\t};\n");
        this.m_outstream.writeBytes("\tprivate int yy_cmap[] = {\n\t\t");
        int i = 0;
        while (i < this.m_spec.m_col_map.length) {
            this.m_outstream.writeBytes(Integer.valueOf(this.m_spec.m_col_map[i]).toString());
            if (i < this.m_spec.m_col_map.length - 1) {
                this.m_outstream.writeBytes(",");
            }
            if ((i + 1) % 8 == 0) {
                this.m_outstream.writeBytes("\n\t\t");
            } else {
                this.m_outstream.writeBytes(" ");
            }
            ++i;
        }
        this.m_outstream.writeBytes("\n\t};\n");
        this.m_outstream.writeBytes("\tprivate int yy_rmap[] = {\n\t\t");
        i = 0;
        while (i < this.m_spec.m_row_map.length) {
            this.m_outstream.writeBytes(Integer.valueOf(this.m_spec.m_row_map[i]).toString());
            if (i < this.m_spec.m_row_map.length - 1) {
                this.m_outstream.writeBytes(",");
            }
            if ((i + 1) % 8 == 0) {
                this.m_outstream.writeBytes("\n\t\t");
            } else {
                this.m_outstream.writeBytes(" ");
            }
            ++i;
        }
        this.m_outstream.writeBytes("\n\t};\n");
        this.m_outstream.writeBytes("\tprivate int yy_nxt[][] = unpackFromString(");
        size = this.m_spec.m_dtrans_vector.size();
        int sequenceLength = 0;
        boolean sequenceStarted = false;
        int previousInt = -20;
        this.m_outstream.writeBytes(Integer.valueOf(size).toString());
        this.m_outstream.writeBytes(",");
        this.m_outstream.writeBytes(Integer.valueOf(this.m_spec.m_dtrans_ncols).toString());
        this.m_outstream.writeBytes(",");
        this.m_outstream.writeBytes("\n\"");
        elem = 0;
        while (elem < size) {
            CDTrans dtrans = (CDTrans)this.m_spec.m_dtrans_vector.elementAt(elem);
            i = 0;
            while (i < this.m_spec.m_dtrans_ncols) {
                int writeInt = dtrans.m_dtrans[i];
                if (writeInt == previousInt) {
                    if (sequenceStarted) {
                        ++sequenceLength;
                    } else {
                        this.m_outstream.writeBytes(Integer.valueOf(writeInt).toString());
                        this.m_outstream.writeBytes(":");
                        sequenceLength = 2;
                        sequenceStarted = true;
                    }
                } else if (sequenceStarted) {
                    this.m_outstream.writeBytes(Integer.valueOf(sequenceLength).toString());
                    this.m_outstream.writeBytes(",");
                    sequenceLength = 0;
                    sequenceStarted = false;
                } else if (previousInt != -20) {
                    this.m_outstream.writeBytes(Integer.valueOf(previousInt).toString());
                    this.m_outstream.writeBytes(",");
                }
                previousInt = writeInt;
                ++i;
            }
            ++elem;
        }
        if (sequenceStarted) {
            this.m_outstream.writeBytes(Integer.valueOf(sequenceLength).toString());
        } else {
            this.m_outstream.writeBytes(Integer.valueOf(previousInt).toString());
        }
        this.m_outstream.writeBytes("\");\n");
    }

    private void emit_driver() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.emit_table();
        if (this.m_spec.m_integer_type) {
            this.m_outstream.writeBytes("\tpublic int ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_function_name));
            this.m_outstream.writeBytes(" ()\n");
        } else if (this.m_spec.m_intwrap_type) {
            this.m_outstream.writeBytes("\tpublic java.lang.Integer ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_function_name));
            this.m_outstream.writeBytes(" ()\n");
        } else {
            this.m_outstream.writeBytes("\tpublic ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_type_name));
            this.m_outstream.writeBytes(" ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_function_name));
            this.m_outstream.writeBytes(" ()\n");
        }
        this.m_outstream.writeBytes("\t\tthrows java.io.IOException");
        if (this.m_spec.m_yylex_throw_code != null) {
            this.m_outstream.writeBytes(", ");
            this.m_outstream.writeBytes(new String(this.m_spec.m_yylex_throw_code, 0, this.m_spec.m_yylex_throw_read));
            this.m_outstream.writeBytes("\n\t\t{\n");
        } else {
            this.m_outstream.writeBytes(" {\n");
        }
        this.m_outstream.writeBytes("\t\tchar yy_lookahead;\n");
        this.m_outstream.writeBytes("\t\tint yy_anchor = YY_NO_ANCHOR;\n");
        this.m_outstream.writeBytes("\t\tint yy_state = yy_state_dtrans[yy_lexical_state];\n");
        this.m_outstream.writeBytes("\t\tint yy_next_state = YY_NO_STATE;\n");
        this.m_outstream.writeBytes("\t\tint yy_last_accept_state = YY_NO_STATE;\n");
        this.m_outstream.writeBytes("\t\tboolean yy_initial = true;\n");
        this.m_outstream.writeBytes("\t\tint yy_this_accept;\n");
        this.m_outstream.writeBytes("\n");
        this.m_outstream.writeBytes("\t\tyy_mark_start();\n");
        this.m_outstream.writeBytes("\t\tyy_this_accept = yy_acpt[yy_state];\n");
        this.m_outstream.writeBytes("\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
        this.m_outstream.writeBytes("\t\t\tyy_last_accept_state = yy_state;\n");
        this.m_outstream.writeBytes("\t\t\tyy_mark_end();\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t\twhile (true) {\n");
        this.m_outstream.writeBytes("\t\t\tyy_lookahead = yy_advance();\n");
        this.m_outstream.writeBytes("\t\t\tyy_next_state = YY_F;\n");
        this.m_outstream.writeBytes("\t\t\tif (YY_EOF != yy_lookahead) {\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\tif (YY_F != yy_next_state) {\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_state = yy_next_state;\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_initial = false;\n");
        this.m_outstream.writeBytes("\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
        this.m_outstream.writeBytes("\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = yy_state;\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_mark_end();\n");
        this.m_outstream.writeBytes("\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\telse {\n");
        this.m_outstream.writeBytes("\t\t\t\tif (YY_EOF == yy_lookahead && true == yy_initial) {\n");
        if (this.m_spec.m_eof_code != null) {
            this.m_outstream.writeBytes("\t\t\t\t\tyy_do_eof();\n");
        }
        if (this.m_spec.m_integer_type || this.m_spec.m_yyeof) {
            this.m_outstream.writeBytes("\t\t\t\t\treturn YYEOF;\n");
        } else if (this.m_spec.m_eof_value_code != null) {
            this.m_outstream.writeBytes(new String(this.m_spec.m_eof_value_code, 0, this.m_spec.m_eof_value_read));
        } else {
            this.m_outstream.writeBytes("\t\t\t\t\treturn null;\n");
        }
        this.m_outstream.writeBytes("\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\telse if (YY_NO_STATE == yy_last_accept_state) {\n");
        this.m_outstream.writeBytes("\t\t\t\t\tthrow (new Error(\"Lexical Error: Unmatched Input.\"));\n");
        this.m_outstream.writeBytes("\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\telse {\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_to_mark();\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_anchor = yy_acpt[yy_last_accept_state];\n");
        this.m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_END & yy_anchor)) {\n");
        this.m_outstream.writeBytes("\t\t\t\t\t\tyy_pushback();\n");
        this.m_outstream.writeBytes("\t\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\t\tif (0 != (YY_START & yy_anchor)) {\n");
        this.m_outstream.writeBytes("\t\t\t\t\t\tyy_move_start();\n");
        this.m_outstream.writeBytes("\t\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\t\tswitch (yy_last_accept_state) {\n");
        this.emit_actions("\t\t\t\t\t");
        this.m_outstream.writeBytes("\t\t\t\t\tdefault:\n");
        this.m_outstream.writeBytes("\t\t\t\t\t\tyy_error(YY_E_INTERNAL,false);\n");
        this.m_outstream.writeBytes("\t\t\t\t\tcase -1:\n");
        this.m_outstream.writeBytes("\t\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_initial = true;\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_state = yy_state_dtrans[yy_lexical_state];\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_next_state = YY_NO_STATE;\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_last_accept_state = YY_NO_STATE;\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_mark_start();\n");
        this.m_outstream.writeBytes("\t\t\t\t\tyy_this_accept = yy_acpt[yy_state];\n");
        this.m_outstream.writeBytes("\t\t\t\t\tif (YY_NOT_ACCEPT != yy_this_accept) {\n");
        this.m_outstream.writeBytes("\t\t\t\t\t\tyy_last_accept_state = yy_state;\n");
        this.m_outstream.writeBytes("\t\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t\t}\n");
        this.m_outstream.writeBytes("\t\t}\n");
        this.m_outstream.writeBytes("\t}\n");
    }

    private void emit_actions(String tabs) throws IOException {
        CUtility.cuassert(this.m_spec.m_accept_vector.size() == this.m_spec.m_anchor_array.length);
        int bogus_index = -2;
        int size = this.m_spec.m_accept_vector.size();
        int elem = 0;
        while (elem < size) {
            CAccept accept = (CAccept)this.m_spec.m_accept_vector.elementAt(elem);
            if (accept != null) {
                this.m_outstream.writeBytes(String.valueOf(tabs) + "case " + elem + ":\n");
                this.m_outstream.writeBytes(String.valueOf(tabs) + "\t");
                this.m_outstream.writeBytes(new String(accept.m_action, 0, accept.m_action_read));
                this.m_outstream.writeBytes("\n");
                this.m_outstream.writeBytes(String.valueOf(tabs) + "case " + bogus_index + ":\n");
                this.m_outstream.writeBytes(String.valueOf(tabs) + "\tbreak;\n");
                --bogus_index;
            }
            ++elem;
        }
    }

    private void emit_footer() throws IOException {
        CUtility.cuassert(this.m_spec != null);
        CUtility.cuassert(this.m_outstream != null);
        this.m_outstream.writeBytes("}\n");
    }
}

