/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx.service;

import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import org.dawb.workbench.jmx.IRemoteServiceProvider;
import org.dawb.workbench.jmx.RemoteWorkbenchAgent;
import org.dawb.workbench.jmx.service.IWorkflowService;
import org.dawb.workbench.jmx.service.RemoteWorkflow;
import org.dawb.workbench.jmx.service.StreamGobbler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WorkflowServiceImpl
implements IWorkflowService {
    private static final Logger logger = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private Process workflow;
    private StreamGobbler out;
    private StreamGobbler err;
    private IRemoteServiceProvider prov;
    private boolean logDirectly = true;
    private RemoteWorkbenchAgent agent;

    public WorkflowServiceImpl(IRemoteServiceProvider iRemoteServiceProvider) {
        this.prov = iRemoteServiceProvider;
    }

    @Override
    public int run() throws Exception {
        Process process = this.start();
        process.waitFor();
        return process.exitValue();
    }

    @Override
    public Process start() throws Exception {
        this.agent = new RemoteWorkbenchAgent(this.prov);
        this.agent.start();
        String string = this.createExecutionLine(this.prov);
        logger.debug("Execution line: " + string);
        String[] stringArray = WorkflowServiceImpl.isLinuxOS() ? new String[]{"/bin/sh", "-c", string} : new String[]{string};
        Map<String, String> map = System.getenv();
        this.workflow = Runtime.getRuntime().exec(stringArray, this.getStringArray(map));
        this.out = new StreamGobbler(this.workflow.getInputStream(), "workflow output");
        this.out.setStreamLogsToLogging(this.logDirectly);
        this.out.start();
        this.err = new StreamGobbler(this.workflow.getErrorStream(), "workflow error");
        this.err.setStreamLogsToLogging(this.logDirectly);
        this.err.start();
        return this.workflow;
    }

    private String[] getStringArray(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (String string : map.keySet()) {
            stringArray[n] = String.valueOf(string) + "=" + map.get(string);
            ++n;
        }
        return stringArray;
    }

    private String createExecutionLine(IRemoteServiceProvider iRemoteServiceProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = iRemoteServiceProvider.getInstallationPath();
        String string2 = iRemoteServiceProvider.getWorkspacePath();
        String string3 = iRemoteServiceProvider.getModelPath();
        int n = this.agent.getCurrentPort();
        boolean bl = iRemoteServiceProvider.getServiceTerminate();
        boolean bl2 = iRemoteServiceProvider.getTangoSpecMockMode();
        stringBuilder.append(string);
        stringBuilder.append(" -noSplash -application com.isencia.passerelle.workbench.model.launch ");
        stringBuilder.append(" -data ");
        stringBuilder.append(string2);
        stringBuilder.append(" -consolelog -vmargs ");
        stringBuilder.append(" -Dmodel=");
        stringBuilder.append(string3);
        stringBuilder.append(" -Dcom.isencia.jmx.service.workspace=");
        stringBuilder.append(string2);
        stringBuilder.append(" -Dcom.isencia.jmx.service.port=");
        stringBuilder.append(n);
        if (bl) {
            stringBuilder.append(" -Dcom.isencia.jmx.service.terminate=true");
        }
        if (bl2) {
            stringBuilder.append(" -Dorg.dawb.test.session=true");
        } else {
            stringBuilder.append(" -Dorg.dawb.test.session=false");
        }
        return stringBuilder.toString();
    }

    @Override
    public void stop(long l) throws Exception {
        try {
            MBeanServerConnection mBeanServerConnection = RemoteWorkflow.getServerConnection(1000L);
            mBeanServerConnection.invoke(RemoteWorkflow.REMOTE_MANAGER, "stop", null, null);
        }
        catch (Exception exception) {
            throw new Exception("Cannot call workflow service for clean stop!", exception);
        }
    }

    @Override
    public String getStandardOut() {
        if (this.out == null) {
            return null;
        }
        return this.out.getStreamDataAsString();
    }

    @Override
    public String getStandardError() {
        if (this.err == null) {
            return null;
        }
        return this.err.getStreamDataAsString();
    }

    @Override
    public boolean isActive(long l) throws Exception {
        if (this.out == null) {
            return false;
        }
        return !this.out.isClosed();
    }

    @Override
    public void clear() throws Exception {
        try {
            this.agent.stop();
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            logger.trace("Service could not be stopped", (Throwable)instanceNotFoundException);
        }
        this.workflow = null;
        this.out = null;
        this.err = null;
        if (this.workflow != null) {
            this.workflow.destroy();
        }
        this.workflow = null;
    }

    @Override
    public void setLogToStandardOut(boolean bl) {
        this.logDirectly = bl;
    }

    public static boolean isLinuxOS() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("linux");
    }
}

