/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamGobbler
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(StreamGobbler.class);
    private boolean streamLogsToLogging = false;
    private InputStreamReader inputStreamReader;
    private boolean inputStreamReaderClosed = false;
    private List<String> streamDataAsList;

    StreamGobbler(InputStream inputStream, String string) {
        super(string);
        this.inputStreamReader = new InputStreamReader(inputStream);
        this.streamDataAsList = new ArrayList<String>();
    }

    public String getStreamDataAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.streamDataAsList) {
            stringBuilder.append(string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public List<String> getStreamDataAsList() {
        return this.streamDataAsList;
    }

    @Override
    public synchronized void run() {
        if (!this.inputStreamReaderClosed) {
            try {
                this.read();
            }
            catch (IOException iOException) {
                logger.error("Error reading from stream by Gobbler " + this.getName(), (Throwable)iOException);
                return;
            }
        }
    }

    private void read() throws IOException {
        BufferedReader bufferedReader = new BufferedReader(this.inputStreamReader);
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (this.streamLogsToLogging) {
                logger.debug(String.valueOf(this.getName()) + "> " + string);
                continue;
            }
            this.streamDataAsList.add(string);
        }
        this.readRemainder();
        this.inputStreamReaderClosed = true;
        bufferedReader.close();
    }

    private void readRemainder() throws IOException {
        int n;
        char[] cArray = new char[80];
        while ((n = this.inputStreamReader.read(cArray, 0, 80)) != -1) {
            logger.trace("_read(): Gobbler '" + this.getName() + "' Ready: " + this.inputStreamReader.ready() + " Value: '" + String.valueOf(cArray, 0, n) + "'");
            if (this.streamLogsToLogging) {
                logger.debug(String.valueOf(this.getName()) + "> " + new String(cArray));
                continue;
            }
            this.streamDataAsList.add(new String(cArray));
        }
    }

    public boolean isClosed() {
        return this.inputStreamReaderClosed;
    }

    public void setStreamLogsToLogging(boolean bl) {
        this.streamLogsToLogging = bl;
    }
}

