/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx.service;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkflow {
    public static ObjectName REMOTE_MANAGER;
    private static Logger logger;

    static {
        logger = LoggerFactory.getLogger(RemoteWorkflow.class);
        try {
            REMOTE_MANAGER = new ObjectName("com.isencia.passerelle.workbench.model.jmx:type=RemoteManager");
        }
        catch (Exception exception) {
            logger.error("Cannot create ObjectName for remotemanager", (Throwable)exception);
        }
    }

    private static final String getHostName() throws UnknownHostException {
        String string = System.getProperty("org.dawb.workbench.jmx.host.name");
        if (string == null) {
            string = InetAddress.getLocalHost().getHostName();
        }
        if (string == null) {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        if (string == null) {
            string = "localhost";
        }
        return string;
    }

    public static MBeanServerConnection getServerConnection(long l) throws Exception {
        if (System.getProperty("com.isencia.jmx.service.port") == null) {
            throw new Exception("You must start the registry before calling this method and set the property 'com.isencia.jmx.service.port'");
        }
        long l2 = 0L;
        MBeanServerConnection mBeanServerConnection = null;
        while (l > l2) {
            l2 += 100L;
            try {
                String string = RemoteWorkflow.getHostName();
                int n = Integer.parseInt(System.getProperty("com.isencia.jmx.service.port"));
                JMXServiceURL jMXServiceURL = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + string + ":" + n + "/workflow");
                JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
                mBeanServerConnection = jMXConnector.getMBeanServerConnection();
                if (mBeanServerConnection != null) break;
                throw new NullPointerException("MBeanServerConnection is null");
            }
            catch (Throwable throwable) {
                if (l2 >= l) {
                    throw new Exception("Cannot get connection. Connection took longer than " + l, throwable);
                }
                Thread.sleep(100L);
            }
        }
        return mBeanServerConnection;
    }
}

