/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx.example;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.dawb.workbench.jmx.IRemoteServiceProvider;
import org.dawb.workbench.jmx.IRemoteWorkbench;
import org.dawb.workbench.jmx.UserInputBean;
import org.dawb.workbench.jmx.service.IWorkflowService;
import org.dawb.workbench.jmx.service.WorkflowFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowExample {
    private static Logger logger;

    private static final void createLoggingProperties() {
        if (System.getProperty("logback.configurationFile") == null) {
            URL uRL = WorkflowExample.class.getResource("logback.xml");
            System.setProperty("logback.configurationFile", uRL.getFile());
        }
        logger = LoggerFactory.getLogger(WorkflowExample.class);
    }

    public static void main(String[] stringArray) throws Exception {
        WorkflowExample.runWorkflow();
        System.exit(1);
    }

    protected static void runWorkflow() throws Exception {
        WorkflowExample.createLoggingProperties();
        IWorkflowService iWorkflowService = WorkflowFactory.createWorkflowService(new ExampleServiceProvider());
        Process process = iWorkflowService.start();
        process.waitFor();
        iWorkflowService.clear();
    }

    private void exampleRunningInThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkflowService iWorkflowService = WorkflowFactory.createWorkflowService(new ExampleServiceProvider());
                    Process process = iWorkflowService.start();
                    try {
                        process.waitFor();
                    }
                    finally {
                        iWorkflowService.clear();
                    }
                }
                catch (Exception exception) {
                    logger.error("Cannot run workflow using Tigermoth", (Throwable)exception);
                }
            }
        });
        thread.setName("Tigermoth Workflow Thead");
        thread.start();
    }

    public static class ExampleRemoteWorkbench
    implements IRemoteWorkbench {
        private Map<String, Object> mockValues;
        private boolean tangoSpecMockMode = true;

        @Override
        public void executionStarted() {
        }

        @Override
        public void executionTerminated(int n) {
        }

        @Override
        public boolean openFile(String string) {
            logger.info("File Open Requested");
            logger.info("Path " + string);
            return true;
        }

        @Override
        public boolean monitorDirectory(String string, boolean bl) {
            logger.info("Directory Monitor Requested");
            logger.info("Path " + string);
            return true;
        }

        @Override
        public boolean refresh(String string, String string2) {
            logger.info("Refresh Requested");
            logger.info("Project " + string + "; path " + string2);
            return true;
        }

        @Override
        public boolean showMessage(String string, String string2, int n) {
            logger.info("Show Message Requested");
            logger.info("Title " + string + "; message " + string2);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            return true;
        }

        @Override
        public void logStatus(String string, String string2, Throwable throwable) {
            logger.error(string2, throwable);
        }

        @Override
        public Map<String, String> createUserInput(UserInputBean userInputBean) throws Exception {
            logger.info("Create User Input Requested");
            logger.info("Actor " + userInputBean.getPartName());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            HashMap<String, String> hashMap = new HashMap<String, String>(3);
            hashMap.put("x", "1");
            return hashMap;
        }

        @Override
        public boolean setActorSelected(String string, String string2, boolean bl, int n) throws Exception {
            logger.info("Select Actor Requested");
            logger.info("Actor " + string2 + "; isSelected " + bl);
            return true;
        }

        @Override
        public void setMockMotorValue(String string, Object object) {
            if (this.mockValues == null) {
                this.mockValues = new HashMap<String, Object>(3);
            }
            this.mockValues.put(string, object);
        }

        @Override
        public Object getMockMotorValue(String string) {
            if (this.mockValues == null) {
                return null;
            }
            return this.mockValues.get(string);
        }

        @Override
        public void notifyMockCommand(String string, String string2, String string3) {
            logger.info("Mock Notify Requested");
            logger.info("Motor " + string + "; message " + string2);
        }
    }

    public static class ExampleServiceProvider
    implements IRemoteServiceProvider {
        @Override
        public IRemoteWorkbench getRemoteWorkbench() throws Exception {
            return new ExampleRemoteWorkbench();
        }

        @Override
        public int getStartPort() {
            return 21701;
        }

        @Override
        public String getWorkspacePath() {
            return "/users/svensson/debug_workspaces";
        }

        @Override
        public String getModelPath() {
            return "/users/svensson/debug_workspace/workflows/examples/command_example.moml";
        }

        @Override
        public String getInstallationPath() {
            return "/opt/dawb/dawb";
        }

        @Override
        public boolean getTangoSpecMockMode() {
            return false;
        }

        @Override
        public boolean getServiceTerminate() {
            return true;
        }
    }
}

