/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx;

import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.StandardMBean;
import org.dawb.workbench.jmx.IRemoteWorkbench;
import org.dawb.workbench.jmx.RemoteWorkbenchMBean;
import org.dawb.workbench.jmx.UserInputBean;

public class RemoteWorkbenchManager
extends StandardMBean
implements RemoteWorkbenchMBean {
    private static final String START_CODE = "org.dawb.workbench.jmx.exec.started";
    private static final String TERM_CODE = "org.dawb.workbench.jmx.exec.terminated";
    private static final String OPEN_CODE = "org.dawb.workbench.jmx.openFile";
    private static final String MOCK_MOTOR_CODE = "org.dawb.workbench.jmx.mockMotor";
    private static final String MOCK_NOTIFY_CODE = "org.dawb.workbench.jmx.mockNotifyCmd";
    private static final String MONITOR_CODE = "org.dawb.workbench.jmx.monitorDir";
    private static final String REFRESH_CODE = "org.dawb.workbench.jmx.refreshProject";
    private static final String MESSAGE_CODE = "org.dawb.workbench.jmx.showMessage";
    private static final String LOG_CODE = "org.dawb.workbench.jmx.logStatus";
    private static final String EDIT_CODE = "org.dawb.workbench.jmx.editScalarValues";
    private static final String ACTOR_SELECTED_CODE = "org.dawb.workbench.jmx.actorSelectedCode";
    private final IRemoteWorkbench rmDelegate;
    private NotificationBroadcasterSupport generalBroadcaster;

    public RemoteWorkbenchManager(IRemoteWorkbench iRemoteWorkbench) throws Exception {
        super(RemoteWorkbenchMBean.class);
        this.rmDelegate = iRemoteWorkbench;
    }

    private void sendNotification(String string) {
        this.sendNotification(string, null);
    }

    private void sendNotification(String string, Object object) {
        if (this.generalBroadcaster != null) {
            Notification notification = new Notification(string, this, -1L);
            notification.setUserData(object);
            this.generalBroadcaster.sendNotification(notification);
        }
    }

    @Override
    public Object getMockMotorValue(String string) {
        Object object = this.rmDelegate.getMockMotorValue(string);
        this.sendNotification(MOCK_MOTOR_CODE);
        return object;
    }

    @Override
    public void setMockMotorValue(String string, Object object) {
        this.rmDelegate.setMockMotorValue(string, object);
        this.sendNotification(MOCK_MOTOR_CODE);
    }

    @Override
    public void notifyMockCommand(String string, String string2, String string3) {
        this.rmDelegate.notifyMockCommand(string, string2, string3);
        this.sendNotification(MOCK_NOTIFY_CODE);
    }

    @Override
    public void executionStarted() {
        this.rmDelegate.executionStarted();
        this.sendNotification(START_CODE);
    }

    @Override
    public void executionTerminated(int n) {
        this.rmDelegate.executionTerminated(n);
        this.sendNotification(TERM_CODE);
    }

    @Override
    public boolean openFile(String string) {
        boolean bl = this.rmDelegate.openFile(string);
        if (bl) {
            this.sendNotification(OPEN_CODE);
        }
        return bl;
    }

    @Override
    public boolean monitorDirectory(String string, boolean bl) {
        boolean bl2 = this.rmDelegate.monitorDirectory(string, bl);
        if (bl2) {
            this.sendNotification(MONITOR_CODE);
        }
        return bl2;
    }

    @Override
    public boolean refresh(String string, String string2) {
        boolean bl = this.rmDelegate.refresh(string, string2);
        if (bl) {
            this.sendNotification(REFRESH_CODE);
        }
        return bl;
    }

    @Override
    public boolean showMessage(String string, String string2, int n) {
        boolean bl = this.rmDelegate.showMessage(string, string2, n);
        this.sendNotification(MESSAGE_CODE);
        return bl;
    }

    @Override
    public void logStatus(String string, String string2, Throwable throwable) {
        this.rmDelegate.logStatus(string, string2, throwable);
        this.sendNotification(LOG_CODE);
    }

    @Override
    public Map<String, String> createUserInput(UserInputBean userInputBean) throws Exception {
        Map<String, String> map = this.rmDelegate.createUserInput(userInputBean);
        this.sendNotification(EDIT_CODE);
        return map;
    }

    @Override
    public boolean setActorSelected(String string, String string2, boolean bl, int n) throws Exception {
        boolean bl2 = this.rmDelegate.setActorSelected(string, string2, bl, n);
        this.sendNotification(ACTOR_SELECTED_CODE);
        return bl2;
    }

    @Override
    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new NotificationBroadcasterSupport();
        }
        this.generalBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{OPEN_CODE}, Notification.class.getName(), "User Notifications.")};
    }

    @Override
    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(notificationListener);
    }
}

