/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.jmx;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ExportException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.dawb.workbench.jmx.IRemoteServiceProvider;
import org.dawb.workbench.jmx.IRemoteWorkbench;
import org.dawb.workbench.jmx.NetUtils;
import org.dawb.workbench.jmx.RemoteWorkbenchMBean;
import org.dawb.workbench.jmx.RemoteWorkbenchManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteWorkbenchAgent {
    public static ObjectName REMOTE_WORKBENCH;
    private static Logger logger;
    private static JMXServiceURL serverUrl;
    private static int currentPort;
    private RemoteWorkbenchMBean remoteManager;

    static {
        logger = LoggerFactory.getLogger(RemoteWorkbenchAgent.class);
    }

    public RemoteWorkbenchAgent(IRemoteServiceProvider iRemoteServiceProvider) throws Exception {
        IRemoteWorkbench iRemoteWorkbench = iRemoteServiceProvider.getRemoteWorkbench();
        this.remoteManager = new RemoteWorkbenchManager(iRemoteWorkbench);
        RemoteWorkbenchAgent.createServerUrl(iRemoteServiceProvider.getStartPort());
    }

    private static final void createServerUrl(int n) {
        if (serverUrl != null) {
            return;
        }
        try {
            String string = System.getProperty("org.dawb.workbench.jmx.host.name");
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
            }
            if (string == null) {
                string = InetAddress.getLocalHost().getHostAddress();
            }
            if (string == null) {
                string = "localhost";
            }
            currentPort = RemoteWorkbenchAgent.getFreePort(n);
            serverUrl = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://" + string + ":" + currentPort + "/workbench");
            REMOTE_WORKBENCH = new ObjectName(String.valueOf(RemoteWorkbenchManager.class.getPackage().getName()) + ":type=RemoteWorkbench");
        }
        catch (Exception exception) {
            logger.error("Cannot create ObjectName for remotemanager", (Throwable)exception);
        }
        logger.debug("Workbench URI: " + serverUrl.getURLPath());
    }

    public int getCurrentPort() {
        return currentPort;
    }

    public void start() throws Exception {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            LocateRegistry.createRegistry(currentPort);
        }
        catch (ExportException exportException) {
            logger.debug("Found existing registry on " + currentPort);
        }
        try {
            if (mBeanServer.getObjectInstance(REMOTE_WORKBENCH) != null) {
                mBeanServer.unregisterMBean(REMOTE_WORKBENCH);
            }
        }
        catch (Exception exception) {}
        mBeanServer.registerMBean(this.remoteManager, REMOTE_WORKBENCH);
        JMXConnectorServer jMXConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(serverUrl, null, mBeanServer);
        jMXConnectorServer.start();
        logger.debug("Workbench service started on " + serverUrl);
    }

    public void stop() throws Exception {
        Registry registry;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (mBeanServer.getObjectInstance(REMOTE_WORKBENCH) != null) {
            mBeanServer.unregisterMBean(REMOTE_WORKBENCH);
            logger.debug("Workbench service stopped on " + serverUrl);
        }
        if ((registry = LocateRegistry.getRegistry(this.getCurrentPort())).lookup("workbench") != null) {
            registry.unbind("workbench");
        }
    }

    public static MBeanServerConnection getServerConnection(long l) throws Exception {
        long l2 = 0L;
        MBeanServerConnection mBeanServerConnection = null;
        RemoteWorkbenchAgent.createServerUrl(21701);
        while (l > l2) {
            l2 += 100L;
            try {
                JMXConnector jMXConnector = JMXConnectorFactory.connect(serverUrl);
                mBeanServerConnection = jMXConnector.getMBeanServerConnection();
                if (mBeanServerConnection != null) break;
                throw new NullPointerException("MBeanServerConnection is null");
            }
            catch (Throwable throwable) {
                if (l2 >= l) {
                    throw new Exception("Cannot get connection", throwable);
                }
                Thread.sleep(100L);
            }
        }
        return mBeanServerConnection;
    }

    /*
     * Unable to fully structure code
     */
    private static int getFreePort(int var0) {
        var1_1 = 21701;
        if (System.getProperty("com.isencia.jmx.service.port") != null) {
            var1_1 = Integer.parseInt(System.getProperty("com.isencia.jmx.service.port"));
            RemoteWorkbenchAgent.logger.debug("Found 'com.isencia.jmx.service.port' set at port " + var1_1);
            return var1_1;
        }
        var1_1 = var0;
        if (!NetUtils.isPortFree(var1_1)) ** GOTO lbl13
        System.setProperty("com.isencia.jmx.service.port", String.valueOf(var1_1));
        RemoteWorkbenchAgent.logger.debug("Used free port at " + var1_1);
        return var1_1;
lbl-1000:
        // 1 sources

        {
            ++var1_1;
lbl13:
            // 2 sources

            ** while (!NetUtils.isPortFree((int)var1_1))
        }
lbl14:
        // 1 sources

        System.setProperty("com.isencia.jmx.service.port", String.valueOf(var1_1));
        RemoteWorkbenchAgent.logger.debug("Assigned free port at " + var1_1);
        return var1_1;
    }
}

