/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.views;

import java.io.File;
import org.dawb.common.services.IFileIconService;
import org.dawb.common.services.ServiceManager;
import org.dawb.common.ui.views.ImageMonitorView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.sda.intro.navigator.NavigatorRCPActivator;
import uk.ac.diamond.sda.navigator.views.FileContentProvider;
import uk.ac.diamond.sda.navigator.views.FileLabelProvider;
import uk.ac.gda.common.rcp.util.EclipseUtils;
import uk.ac.gda.ui.actions.CheckableActionGroup;
import uk.ac.gda.ui.content.FileContentProposalProvider;
import uk.ac.gda.util.OSUtils;

public class FileView
extends ViewPart {
    public static final String ID = "uk.ac.diamond.sda.navigator.views.FileView";
    private static final Logger logger = LoggerFactory.getLogger(FileView.class);
    private TreeViewer tree;
    private File savedSelection;
    private File root = OSUtils.isWindowsOS() ? new File("C:/") : new File("/");
    private boolean rootOverride;
    private Text filePath;

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        String string;
        super.init(iViewSite, iMemento);
        String string2 = null;
        if (iMemento != null) {
            string2 = iMemento.getString("DIR");
        }
        if (string2 == null) {
            string2 = System.getProperty("uk.ac.diamond.sda.navigator.default.file.view.location");
        }
        if (string2 == null) {
            string2 = System.getProperty("user.home");
        }
        if (string2 != null) {
            this.savedSelection = new File(string2);
        }
        this.rootOverride = false;
        if (iMemento != null && (string = iMemento.getString("ROOT_DIR")) != null) {
            this.root = new File(string);
            this.rootOverride = true;
            if (this.savedSelection.getAbsolutePath().indexOf(string) <= -1) {
                this.savedSelection = this.root;
            }
        }
    }

    public void setRoot(File file) throws Exception {
        if (!file.isDirectory()) {
            throw new Exception("Must choose a directory!");
        }
        this.root = file;
        this.setSelectedFile(file.getAbsolutePath());
        this.rootOverride = true;
        this.filePath.setEnabled(false);
        this.filePath.setEditable(false);
        FileContentProvider fileContentProvider = (FileContentProvider)this.tree.getContentProvider();
        fileContentProvider.clearAndStop();
        this.createContent(false);
    }

    public void saveState(IMemento iMemento) {
        if (iMemento == null) {
            return;
        }
        if (this.getSelectedFile() != null) {
            String string = this.getSelectedFile().getAbsolutePath();
            iMemento.putString("DIR", string);
        }
        if (this.root != null && this.rootOverride) {
            iMemento.putString("ROOT_DIR", this.root.getAbsolutePath());
        }
    }

    public File getSelectedFile() {
        File file = (File)((IStructuredSelection)this.tree.getSelection()).getFirstElement();
        if (file == null) {
            file = this.savedSelection;
        }
        return file;
    }

    public String[] getSelectedFiles() {
        Object[] objectArray = ((IStructuredSelection)this.tree.getSelection()).toArray();
        if (this.tree.getSelection() == null || this.tree.getSelection().isEmpty()) {
            objectArray = new Object[]{this.savedSelection};
        }
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = ((File)objectArray[n]).getAbsolutePath();
            ++n;
        }
        return stringArray;
    }

    public void createPartControl(Composite composite) {
        Image image;
        IFileIconService iFileIconService;
        composite.setLayout((Layout)new GridLayout(1, false));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(4, 4, false, false));
        Label label = new Label(composite2, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        try {
            iFileIconService = (IFileIconService)ServiceManager.getService(IFileIconService.class);
            image = iFileIconService.getIconForFile(OSUtils.isWindowsOS() ? new File("C:/Windows/") : new File("/"));
            label.setImage(image);
        }
        catch (Exception exception) {
            logger.error("Cannot get icon for system root!", (Throwable)exception);
        }
        this.filePath = new Text(composite2, 2048);
        if (this.rootOverride) {
            this.filePath.setEnabled(false);
            this.filePath.setEditable(false);
        }
        if (this.savedSelection != null) {
            this.filePath.setText(this.savedSelection.getAbsolutePath());
        }
        this.filePath.setLayoutData((Object)new GridData(4, 4, true, true));
        iFileIconService = new FileContentProposalProvider();
        image = new ContentProposalAdapter((Control)this.filePath, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)iFileIconService, null, null);
        image.setProposalAcceptanceStyle(2);
        image.addContentProposalListener(new IContentProposalListener(){

            public void proposalAccepted(IContentProposal iContentProposal) {
                FileView.this.setSelectedFile(FileView.this.filePath.getText());
            }
        });
        this.filePath.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileView.this.setSelectedFile(FileView.this.filePath.getText());
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                FileView.this.setSelectedFile(FileView.this.filePath.getText());
            }
        });
        this.tree = new TreeViewer(composite, 268503810);
        this.tree.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.tree.getTree().setHeaderVisible(true);
        this.tree.setUseHashlookup(true);
        this.tree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                File file = FileView.this.getSelectedFile();
                if (file != null && file.isDirectory()) {
                    FileView.this.filePath.setText(file.getAbsolutePath());
                    FileView.this.filePath.setSelection(FileView.this.filePath.getText().length());
                }
            }
        });
        String[] stringArray = new String[]{"Name", "Date", "Type", "Size"};
        int[] nArray = new int[]{250, 120, 80, 150};
        int n = 0;
        while (n < stringArray.length) {
            TreeViewerColumn treeViewerColumn = new TreeViewerColumn(this.tree, 0);
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            treeColumn.setText(stringArray[n]);
            treeColumn.setWidth(nArray[n]);
            treeColumn.setMoveable(true);
            try {
                treeViewerColumn.setLabelProvider((CellLabelProvider)new FileLabelProvider(n));
            }
            catch (Exception exception) {
                logger.error("Cannot create label provider " + n, (Throwable)exception);
            }
            ++n;
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tree);
        this.createContent(true);
        DragSource dragSource = new DragSource(this.tree.getControl(), 19);
        dragSource.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent dragSourceEvent) {
                if (FileView.this.getSelectedFiles() == null) {
                    return;
                }
                dragSourceEvent.data = FileView.this.getSelectedFiles();
            }
        });
        this.tree.getTree().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                FileView.this.openSelectedFile();
            }
        });
        this.tree.getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\n') {
                    FileView.this.openSelectedFile();
                }
            }
        });
        this.createRightClickMenu();
        this.addToolbar();
        if (this.savedSelection != null) {
            if (this.savedSelection.exists()) {
                this.tree.setSelection((ISelection)new StructuredSelection((Object)this.savedSelection));
            } else if (this.savedSelection.getParentFile().exists()) {
                this.tree.setSelection((ISelection)new StructuredSelection((Object)this.savedSelection.getParentFile()));
            }
        }
    }

    public void collapseAll() {
        this.tree.collapseAll();
    }

    public void refresh() {
        File file = this.getSelectedFile();
        this.refresh(file);
    }

    protected void refresh(File file) {
        Object[] objectArray = file == null ? this.tree.getExpandedElements() : null;
        FileContentProvider fileContentProvider = (FileContentProvider)this.tree.getContentProvider();
        fileContentProvider.clearAndStop();
        this.tree.refresh(file != null ? file.getParentFile() : this.tree.getInput());
        if (objectArray != null) {
            this.tree.setExpandedElements(objectArray);
        }
        if (file != null) {
            this.tree.setExpandedState((Object)file.getParentFile(), true);
            this.tree.setExpandedState((Object)file, true);
            this.tree.setSelection((ISelection)new StructuredSelection((Object)file));
        }
    }

    private void createContent(boolean bl) {
        if (bl) {
            this.tree.getTree().setItemCount(this.root.listFiles().length);
        }
        this.tree.setContentProvider((IContentProvider)new FileContentProvider());
        this.tree.setInput((Object)this.root);
        this.tree.expandToLevel(1);
    }

    public void setSelectedFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.tree.setSelection((ISelection)new StructuredSelection((Object)file));
            this.tree.setExpandedState((Object)file, true);
        }
    }

    private void createRightClickMenu() {
        MenuManager menuManager = new MenuManager();
        this.tree.getControl().setMenu(menuManager.createContextMenu(this.tree.getControl()));
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)this.tree);
    }

    private void addToolbar() {
        IToolBarManager iToolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        Action action = new Action("Sort alpha numeric, directories at top.", 2){

            public void run() {
                File file = FileView.this.getSelectedFile();
                ((FileContentProvider)FileView.this.tree.getContentProvider()).setSort(FileContentProvider.FileSortType.ALPHA_NUMERIC_DIRS_FIRST);
                FileView.this.tree.refresh();
                if (file != null) {
                    FileView.this.tree.setSelection((ISelection)new StructuredSelection((Object)file));
                }
            }
        };
        action.setImageDescriptor(NavigatorRCPActivator.getImageDescriptor("icons/alpha_mode_folder.png"));
        action.setChecked(true);
        checkableActionGroup.add((IAction)action);
        iToolBarManager.add((IAction)action);
        Action action2 = new Action("Alpha numeric sort for everything.", 2){

            public void run() {
                File file = FileView.this.getSelectedFile();
                ((FileContentProvider)FileView.this.tree.getContentProvider()).setSort(FileContentProvider.FileSortType.ALPHA_NUMERIC);
                FileView.this.tree.refresh();
                if (file != null) {
                    FileView.this.tree.setSelection((ISelection)new StructuredSelection((Object)file));
                }
            }
        };
        action2.setImageDescriptor(NavigatorRCPActivator.getImageDescriptor("icons/alpha_mode.gif"));
        checkableActionGroup.add((IAction)action2);
        iToolBarManager.add((IAction)action2);
        iToolBarManager.add((IContributionItem)new Separator("uk.ac.diamond.sda.navigator.views.monitorSep"));
    }

    protected void openSelectedFile() {
        File file = this.getSelectedFile();
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            IWorkbenchPage iWorkbenchPage = EclipseUtils.getActivePage();
            if (iWorkbenchPage == null) {
                return;
            }
            IViewPart iViewPart = null;
            try {
                iViewPart = iWorkbenchPage.showView("org.dawb.workbench.views.imageMonitorView");
            }
            catch (PartInitException partInitException) {
                logger.error("TODO put description of error here", (Throwable)partInitException);
                return;
            }
            if (iViewPart != null && iViewPart instanceof ImageMonitorView) {
                ((ImageMonitorView)iViewPart).setDirectoryPath(file.getAbsolutePath());
            }
        } else {
            try {
                EclipseUtils.openExternalEditor((String)file.getAbsolutePath());
            }
            catch (PartInitException partInitException) {
                logger.error("Cannot open file " + file, (Throwable)partInitException);
            }
        }
    }

    public void dispose() {
        super.dispose();
    }

    public void setFocus() {
        this.tree.getControl().setFocus();
    }

    public Object getAdapter(Class clazz) {
        return super.getAdapter(clazz);
    }
}

