/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.views;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dawb.common.services.IFileIconService;
import org.dawb.common.services.ServiceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import uk.ac.gda.util.io.FileUtils;

public class FileLabelProvider
extends ColumnLabelProvider {
    private int columnIndex;
    private SimpleDateFormat dateFormat;
    private IFileIconService service;
    private static final double BASE = 1024.0;
    private static final double KB = 1024.0;
    private static final double MB = 1048576.0;
    private static final double GB = 1.073741824E9;
    private static final DecimalFormat df = new DecimalFormat("#.##");

    public FileLabelProvider(int n) throws Exception {
        this.columnIndex = n;
        this.dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        this.service = (IFileIconService)ServiceManager.getService(IFileIconService.class);
    }

    public Color getForeground(Object object) {
        if (this.columnIndex == 0) {
            return null;
        }
        return Display.getCurrent().getSystemColor(16);
    }

    public Image getImage(Object object) {
        File file = (File)object;
        switch (this.columnIndex) {
            case 0: {
                try {
                    return this.service.getIconForFile(file);
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        }
        return null;
    }

    public String getText(Object object) {
        File file = (File)object;
        switch (this.columnIndex) {
            case 0: {
                return file.getName();
            }
            case 1: {
                return this.dateFormat.format(new Date(file.lastModified()));
            }
            case 2: {
                return file.isDirectory() ? "Directory" : FileUtils.getFileExtension((File)file);
            }
            case 3: {
                return FileLabelProvider.formatSize(file.length());
            }
        }
        return null;
    }

    public static String formatSize(double d) {
        if (d >= 1.073741824E9) {
            return String.valueOf(df.format(d / 1.073741824E9)) + " GB";
        }
        if (d >= 1048576.0) {
            return String.valueOf(df.format(d / 1048576.0)) + " MB";
        }
        if (d >= 1024.0) {
            return String.valueOf(df.format(d / 1024.0)) + " KB";
        }
        return (int)d + " bytes";
    }
}

