/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.views;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jface.viewers.ILazyTreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.ui.PlatformUI;
import uk.ac.gda.util.io.SortingUtils;

public class FileContentProvider
implements ILazyTreeContentProvider {
    private TreeViewer treeViewer;
    private FileSortType sort = FileSortType.ALPHA_NUMERIC_DIRS_FIRST;
    private BlockingQueue<UpdateRequest> elementQueue;
    private BlockingQueue<UpdateRequest> childQueue;
    private Thread updateElementThread;
    private Thread updateChildThread;
    private Map<File, List<File>> cachedSorting = new WeakHashMap<File, List<File>>(89);
    private static Cursor busy;
    private static boolean isBusy;

    static {
        isBusy = false;
    }

    public FileContentProvider() {
        this.elementQueue = new LinkedBlockingDeque<UpdateRequest>(Integer.MAX_VALUE);
        this.childQueue = new LinkedBlockingDeque<UpdateRequest>(Integer.MAX_VALUE);
    }

    public void dispose() {
        this.clearAndStop();
        this.elementQueue = null;
        this.childQueue = null;
    }

    private void clear() {
        if (this.elementQueue != null) {
            this.elementQueue.clear();
        }
        if (this.childQueue != null) {
            this.childQueue.clear();
        }
        if (this.cachedSorting != null) {
            this.cachedSorting.clear();
        }
    }

    public void clearAndStop() {
        this.clear();
        this.elementQueue.add(new BlankUpdateRequest());
        this.updateElementThread = null;
        this.childQueue.add(new BlankUpdateRequest());
        this.updateChildThread = null;
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.treeViewer = (TreeViewer)viewer;
        this.treeViewer.refresh();
    }

    public void updateElement(Object object, int n) {
        if (this.elementQueue == null) {
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            if (this.updateElementThread == null) {
                this.updateElementThread = this.createUpdateThread(this.elementQueue, 9, "Update directory contents");
            }
            this.elementQueue.add(new ElementUpdateRequest(object, n));
        } else {
            File file = (File)object;
            List<File> list = this.getFileList(file);
            this.updateElementInternal(file, n, list);
        }
    }

    public void updateElementInternal(Object object, int n, List<File> list) {
        if (list != null && n < list.size()) {
            File file = list.get(n);
            this.treeViewer.replace(object, n, (Object)file);
            if (file.isDirectory()) {
                this.treeViewer.setChildCount((Object)file, 1);
                if (this.updateChildThread == null) {
                    this.updateChildThread = this.createUpdateThread(this.childQueue, 2, "Update child size");
                }
                this.childQueue.add(new ChildUpdateRequest((Object)file, false));
            } else {
                this.treeViewer.setChildCount((Object)file, 0);
            }
        }
    }

    public void updateChildCount(Object object, int n) {
        if (this.childQueue == null) {
            return;
        }
        File file = (File)object;
        if (!file.isDirectory()) {
            this.treeViewer.setChildCount((Object)file, 0);
            return;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            if (this.updateChildThread == null) {
                this.updateChildThread = this.createUpdateThread(this.childQueue, 2, "Update child size");
            }
            this.childQueue.add(new ChildUpdateRequest(object, true));
        } else {
            this.updateChildCountInternal(object, n);
        }
    }

    private void updateChildCountInternal(Object object, int n) {
        File file = (File)object;
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.treeViewer.setChildCount((Object)file, n);
        } else {
            this.treeViewer.setChildCount((Object)file, 0);
        }
    }

    private List<File> getFileList(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        if (this.cachedSorting == null) {
            return null;
        }
        if (this.sort == FileSortType.ALPHA_NUMERIC) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return null;
            }
            return Arrays.asList(fileArray);
        }
        if (this.cachedSorting.containsKey(file)) {
            return this.cachedSorting.get(file);
        }
        List list = this.sort == FileSortType.ALPHA_NUMERIC ? SortingUtils.getSortedFileList((File)file, (boolean)false) : SortingUtils.getSortedFileList((File)file, (boolean)true);
        this.cachedSorting.put(file, list);
        return list;
    }

    public Object getParent(Object object) {
        if (object == null || !(object instanceof File)) {
            return null;
        }
        File file = (File)object;
        return file.getParentFile();
    }

    public FileSortType getSort() {
        return this.sort;
    }

    public void setSort(FileSortType fileSortType) {
        this.sort = fileSortType;
    }

    private Thread createUpdateThread(final BlockingQueue<UpdateRequest> blockingQueue, int n, String string) {
        Thread thread = new Thread(string){

            @Override
            public void run() {
                while (!FileContentProvider.this.treeViewer.getControl().isDisposed() && blockingQueue != null) {
                    try {
                        UpdateRequest updateRequest = (UpdateRequest)blockingQueue.take();
                        if (updateRequest.getElement() == null && updateRequest.getIndex() == -1) {
                            return;
                        }
                        if (updateRequest instanceof BlankUpdateRequest) {
                            return;
                        }
                        boolean bl = updateRequest.process();
                        if (bl) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    catch (SWTException sWTException) {
                        blockingQueue.clear();
                        break;
                    }
                    catch (Exception exception) {
                        blockingQueue.clear();
                    }
                }
            }
        };
        thread.setPriority(n);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static void main(String[] stringArray) {
        File file = new File("E:/Data_Backup/ID22-ODA-Complete");
        long l = System.currentTimeMillis();
        file.listFiles();
        long l2 = System.currentTimeMillis();
        System.out.print("Time to listFiles(): " + (l2 - l) + "\n");
        l = System.currentTimeMillis();
        file.list();
        l2 = System.currentTimeMillis();
        System.out.print("Time to list(): " + (l2 - l) + "\n");
    }

    private class BlankUpdateRequest
    extends UpdateRequest {
        private BlankUpdateRequest() {
        }

        @Override
        public boolean process() throws Exception {
            return false;
        }
    }

    private class ChildUpdateRequest
    extends UpdateRequest {
        private boolean updateBusyRequired;

        public ChildUpdateRequest(Object object, boolean bl) {
            this.element = object;
            this.updateBusyRequired = bl;
        }

        @Override
        public boolean process() throws Exception {
            try {
                File file;
                String[] stringArray;
                int n;
                if (this.updateBusyRequired) {
                    this.updateBusy(FileContentProvider.this.childQueue, true);
                }
                int n2 = n = (stringArray = (file = (File)this.element).list()) == null || stringArray.length < 1 ? 0 : stringArray.length;
                if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                    return false;
                }
                FileContentProvider.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        FileContentProvider.this.updateChildCountInternal(file, n);
                    }
                });
            }
            finally {
                if (this.updateBusyRequired) {
                    this.updateBusy(FileContentProvider.this.childQueue, true);
                }
            }
            return true;
        }
    }

    private class ElementUpdateRequest
    extends UpdateRequest {
        public ElementUpdateRequest(Object object, int n) {
            super(object, n);
        }

        @Override
        public boolean process() throws Exception {
            try {
                this.updateBusy(FileContentProvider.this.elementQueue, true);
                final File file = (File)this.getElement();
                final List list = FileContentProvider.this.getFileList(file);
                if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                    return false;
                }
                FileContentProvider.this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        FileContentProvider.this.updateElementInternal(file, ElementUpdateRequest.this.getIndex(), list);
                    }
                });
            }
            finally {
                this.updateBusy(FileContentProvider.this.elementQueue, false);
            }
            return true;
        }
    }

    public static enum FileSortType {
        ALPHA_NUMERIC,
        ALPHA_NUMERIC_DIRS_FIRST;

    }

    private abstract class UpdateRequest {
        protected Object element;
        protected int index;

        UpdateRequest() {
            this.element = null;
            this.index = -1;
            if (busy == null) {
                busy = FileContentProvider.this.treeViewer.getControl().getDisplay().getSystemCursor(1);
            }
        }

        UpdateRequest(Object object, int n) {
            this.element = object;
            this.index = n;
        }

        public Object getElement() {
            return this.element;
        }

        public int getIndex() {
            return this.index;
        }

        public abstract boolean process() throws Exception;

        protected void updateBusy(BlockingQueue<UpdateRequest> blockingQueue, boolean bl) {
            if (bl && !isBusy) {
                isBusy = true;
                if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                    return;
                }
                FileContentProvider.this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        FileContentProvider.this.treeViewer.getControl().setCursor(busy);
                    }
                });
            }
            if (!bl && blockingQueue.isEmpty()) {
                if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                    return;
                }
                FileContentProvider.this.treeViewer.getControl().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FileContentProvider.this.treeViewer.getControl().isDisposed()) {
                            return;
                        }
                        FileContentProvider.this.treeViewer.getControl().setCursor(null);
                        isBusy = false;
                    }
                });
            }
        }
    }
}

