/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.srs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.rcp.navigator.srs.SRSTreeData;

public class SRSContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final String SRS_EXT = "dat";
    private final Map cachedModelMap = new HashMap();
    private static StructuredViewer viewer;
    protected static String fileName;
    private DataHolder data;
    private IMetaData metaData;
    private static final Logger logger;

    static {
        logger = LoggerFactory.getLogger(SRSContentProvider.class);
    }

    public SRSContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object object) {
        IFile iFile;
        Object[] objectArray = null;
        if (object instanceof SRSTreeData) {
            objectArray = NO_CHILDREN;
        } else if (object instanceof IFile && SRS_EXT.equals((iFile = (IFile)object).getFileExtension()) && (objectArray = (SRSTreeData[])this.cachedModelMap.get(iFile)) == null && this.updateModel(iFile) != null) {
            objectArray = (SRSTreeData[])this.cachedModelMap.get(iFile);
        }
        return objectArray != null ? objectArray : NO_CHILDREN;
    }

    public void srsFileLoader(IFile iFile) {
        fileName = iFile.getLocation().toString();
        try {
            this.metaData = LoaderFactory.getMetaData((String)fileName, null);
        }
        catch (Exception exception) {
            logger.error("Cannot open dat file", (Throwable)exception);
        }
    }

    private synchronized IMetaData updateModel(IFile iFile) {
        this.srsFileLoader(iFile);
        if (SRS_EXT.equals(iFile.getFileExtension())) {
            if (iFile.exists()) {
                ArrayList<SRSTreeData> arrayList = new ArrayList<SRSTreeData>();
                Collection collection = this.metaData.getDataNames();
                String[] stringArray = new String[collection.size()];
                int n = 0;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    stringArray[n] = (String)iterator.next();
                    ++n;
                }
                int n2 = 0;
                while (n2 < stringArray.length) {
                    arrayList.add(new SRSTreeData(stringArray[n2].trim(), "", "", "", iFile));
                    ++n2;
                }
                SRSTreeData[] sRSTreeDataArray = arrayList.toArray(new SRSTreeData[arrayList.size()]);
                this.cachedModelMap.put(iFile, sRSTreeDataArray);
                return this.metaData;
            }
            this.cachedModelMap.remove(iFile);
        }
        return null;
    }

    public Object getParent(Object object) {
        if (object instanceof SRSTreeData) {
            SRSTreeData sRSTreeData = (SRSTreeData)object;
            return sRSTreeData.getFile();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof SRSTreeData) {
            return false;
        }
        if (object instanceof IFile) {
            return SRS_EXT.equals(((IFile)object).getFileExtension());
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        this.cachedModelMap.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object != null && !object.equals(object2)) {
            this.cachedModelMap.clear();
        }
        SRSContentProvider.viewer = (StructuredViewer)viewer;
        SRSContentProvider.viewer.setComparator(null);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            iResourceDelta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        switch (iResource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                final IFile iFile = (IFile)iResource;
                if (SRS_EXT.equals(iFile.getFileExtension())) {
                    this.updateModel(iFile);
                    new UIJob("Update SRS Model in CommonViewer"){

                        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                            if (viewer != null && !viewer.getControl().isDisposed()) {
                                viewer.refresh((Object)iFile);
                                viewer.setComparator(null);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return false;
            }
        }
        return false;
    }

    public DataHolder getData() {
        return this.data;
    }

    public void setData(DataHolder dataHolder) {
        this.data = dataHolder;
    }
}

