/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.properties.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import uk.ac.diamond.sda.intro.navigator.NavigatorRCPActivator;
import uk.ac.diamond.sda.navigator.properties.PropertiesTreeData;

public class OpenPropertyAction
extends Action {
    private IWorkbenchPage page;
    private PropertiesTreeData data;
    private ISelectionProvider provider;

    public OpenPropertyAction(IWorkbenchPage iWorkbenchPage, ISelectionProvider iSelectionProvider) {
        this.setText("Open Property");
        this.page = iWorkbenchPage;
        this.provider = iSelectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.provider.getSelection();
        if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof PropertiesTreeData) {
            this.data = (PropertiesTreeData)iStructuredSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        block4: {
            try {
                IFile iFile;
                IEditorPart iEditorPart;
                if (!this.isEnabled() || !((iEditorPart = IDE.openEditor((IWorkbenchPage)this.page, (IFile)(iFile = this.data.getFile()))) instanceof ITextEditor)) break block4;
                ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
                IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorPart.getEditorInput());
                FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(iDocument);
                try {
                    String string = String.valueOf(this.data.getName()) + "=";
                    IRegion iRegion = findReplaceDocumentAdapter.find(0, string, true, true, false, false);
                    ((ITextEditor)iEditorPart).selectAndReveal(iRegion.getOffset(), iRegion.getLength());
                }
                catch (BadLocationException badLocationException) {
                    NavigatorRCPActivator.logError(0, "Could not open property!", badLocationException);
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Opening Property", (String)"Could not open property!");
                }
                return;
            }
            catch (PartInitException partInitException) {
                NavigatorRCPActivator.logError(0, "Could not open property!", partInitException);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Opening Property", (String)"Could not open property!");
            }
        }
    }
}

