/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.properties.actions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import uk.ac.diamond.sda.intro.navigator.NavigatorRCPActivator;
import uk.ac.diamond.sda.navigator.properties.PropertiesTreeData;

public class DeletePropertyAction
extends ActionDelegate {
    private IStructuredSelection selection = StructuredSelection.EMPTY;

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.selection = iSelection instanceof IStructuredSelection ? (IStructuredSelection)iSelection : StructuredSelection.EMPTY;
    }

    public void run(IAction iAction) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask("Deleting property from selection", 5);
                try {
                    if (DeletePropertyAction.this.selection.size() == 1) {
                        Object object = DeletePropertyAction.this.selection.getFirstElement();
                        if (object instanceof PropertiesTreeData) {
                            PropertiesTreeData propertiesTreeData = (PropertiesTreeData)object;
                            IFile iFile = propertiesTreeData.getFile();
                            iProgressMonitor.worked(1);
                            if (iFile != null && iFile.isAccessible()) {
                                try {
                                    Properties properties = new Properties();
                                    properties.load(iFile.getContents());
                                    iProgressMonitor.worked(1);
                                    properties.remove(propertiesTreeData.getName());
                                    iProgressMonitor.worked(1);
                                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                                    properties.store(byteArrayOutputStream, null);
                                    iProgressMonitor.worked(1);
                                    iFile.setContents((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), 3, iProgressMonitor);
                                    iProgressMonitor.worked(1);
                                }
                                catch (IOException iOException) {
                                    NavigatorRCPActivator.logError(0, "Could not delete property!", iOException);
                                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"Could not delete property!");
                                }
                            } else {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"The properties file was not accessible!");
                            }
                        } else {
                            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"The element that was selected was not of the right type.");
                        }
                    } else {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"An invalid number of properties were selected.");
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (InvocationTargetException invocationTargetException) {
            NavigatorRCPActivator.logError(0, "Could not delete property!", invocationTargetException);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"Could not delete property!");
        }
        catch (InterruptedException interruptedException) {
            NavigatorRCPActivator.logError(0, "Could not delete property!", interruptedException);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Deleting Property", (String)"Could not delete property!");
        }
    }
}

