/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.properties;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.progress.UIJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.sda.navigator.properties.PropertiesTreeData;

public class PropertiesContentProvider
implements ITreeContentProvider,
IResourceChangeListener,
IResourceDeltaVisitor {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesContentProvider.class);
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final Object PROPERTIES_EXT = "properties";
    private final Map cachedModelMap = new HashMap();
    private StructuredViewer viewer;

    public PropertiesContentProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public Object[] getChildren(Object object) {
        IFile iFile;
        Object[] objectArray = null;
        if (object instanceof PropertiesTreeData) {
            objectArray = NO_CHILDREN;
        } else if (object instanceof IFile && PROPERTIES_EXT.equals((iFile = (IFile)object).getFileExtension()) && (objectArray = (PropertiesTreeData[])this.cachedModelMap.get(iFile)) == null && this.updateModel(iFile) != null) {
            objectArray = (PropertiesTreeData[])this.cachedModelMap.get(iFile);
        }
        return objectArray != null ? objectArray : NO_CHILDREN;
    }

    private synchronized Properties updateModel(IFile iFile) {
        if (PROPERTIES_EXT.equals(iFile.getFileExtension())) {
            Properties properties = new Properties();
            if (iFile.exists()) {
                try {
                    properties.load(iFile.getContents());
                    ArrayList<PropertiesTreeData> arrayList = new ArrayList<PropertiesTreeData>();
                    PropertiesTreeData[] propertiesTreeDataArray = properties.propertyNames();
                    while (propertiesTreeDataArray.hasMoreElements()) {
                        String string = (String)propertiesTreeDataArray.nextElement();
                        arrayList.add(new PropertiesTreeData(string, properties.getProperty(string), iFile));
                    }
                    propertiesTreeDataArray = arrayList.toArray(new PropertiesTreeData[arrayList.size()]);
                    this.cachedModelMap.put(iFile, propertiesTreeDataArray);
                    return properties;
                }
                catch (IOException iOException) {
                }
                catch (CoreException coreException) {}
            } else {
                this.cachedModelMap.remove(iFile);
            }
        }
        return null;
    }

    public Object getParent(Object object) {
        if (object instanceof PropertiesTreeData) {
            PropertiesTreeData propertiesTreeData = (PropertiesTreeData)object;
            logger.debug(propertiesTreeData.getFile().toString());
            return propertiesTreeData.getFile();
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof PropertiesTreeData) {
            return false;
        }
        if (object instanceof IFile) {
            return PROPERTIES_EXT.equals(((IFile)object).getFileExtension());
        }
        return false;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void dispose() {
        this.cachedModelMap.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        if (object != null && !object.equals(object2)) {
            this.cachedModelMap.clear();
        }
        this.viewer = (StructuredViewer)viewer;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            iResourceDelta.accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
    }

    public boolean visit(IResourceDelta iResourceDelta) {
        IResource iResource = iResourceDelta.getResource();
        switch (iResource.getType()) {
            case 2: 
            case 4: 
            case 8: {
                return true;
            }
            case 1: {
                final IFile iFile = (IFile)iResource;
                if (PROPERTIES_EXT.equals(iFile.getFileExtension())) {
                    this.updateModel(iFile);
                    new UIJob("Update Properties Model in CommonViewer"){

                        public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                            if (PropertiesContentProvider.this.viewer != null && !PropertiesContentProvider.this.viewer.getControl().isDisposed()) {
                                PropertiesContentProvider.this.viewer.refresh((Object)iFile);
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return false;
            }
        }
        return false;
    }
}

