/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.hdf5;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.IDescriptionProvider;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;

public class HDF5LabelProvider
extends LabelProvider
implements ILabelProvider,
ILabelDecorator,
IDescriptionProvider {
    public static final String ID = "uk.ac.diamond.sda.navigator.hdf5Decorator";

    public Image getImage(Object object) {
        if (object instanceof HDF5Attribute) {
            return new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/hdf5/dataset.gif"));
        }
        HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        if (hDF5Node instanceof HDF5Dataset) {
            HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5Node;
            if (hDF5Dataset.isString()) {
                return new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/hdf5/text.gif"));
            }
            ILazyDataset iLazyDataset = hDF5Dataset.getDataset();
            if (iLazyDataset instanceof AbstractDataset) {
                return new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/hdf5/dataset.gif"));
            }
            return new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/hdf5/dataset.gif"));
        }
        return new Image((Device)Display.getCurrent(), ((Object)((Object)this)).getClass().getResourceAsStream("/icons/hdf5/folderopen.gif"));
    }

    public String getText(Object object) {
        return object instanceof HDF5Attribute ? String.valueOf(((HDF5Attribute)object).getName()) + " " : String.valueOf(((HDF5NodeLink)object).getName()) + " ";
    }

    public String getDescription(Object object) {
        HDF5Dataset hDF5Dataset;
        String string = "";
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            return String.valueOf(iFile.getName()) + " " + iFile.getFullPath();
        }
        if (object instanceof HDF5Attribute) {
            HDF5Attribute hDF5Attribute = (HDF5Attribute)object;
            string = hDF5Attribute.getName();
            return string;
        }
        assert (object instanceof HDF5NodeLink) : "Not an attribute or a link";
        HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        string = hDF5NodeLink.getName();
        if (hDF5Node instanceof HDF5Dataset && !(hDF5Dataset = (HDF5Dataset)hDF5Node).isSupported()) {
            return "Not supported";
        }
        return string;
    }

    public Image decorateImage(Image image, Object object) {
        return image;
    }

    public String decorateText(String string, Object object) {
        if (object instanceof HDF5Attribute) {
            HDF5Attribute hDF5Attribute = (HDF5Attribute)object;
            string = String.valueOf(string) + "Attr ";
            if (hDF5Attribute.getSize() > 1) {
                int[] nArray = hDF5Attribute.getShape();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3 = nArray[n2];
                    string = String.valueOf(string) + n3 + ", ";
                    ++n2;
                }
                if (string.length() > 2) {
                    string = String.valueOf(string) + string.substring(0, string.length() - 2) + " ";
                }
            }
            string = String.valueOf(string) + hDF5Attribute.getTypeName() + " ";
            string = String.valueOf(string) + (hDF5Attribute.getSize() == 1 ? String.valueOf(hDF5Attribute.getFirstElement()) + " " : String.valueOf(hDF5Attribute.toString()) + " ");
            return string;
        }
        assert (object instanceof HDF5NodeLink) : "Not an attribute or a link";
        HDF5NodeLink hDF5NodeLink = (HDF5NodeLink)object;
        HDF5Node hDF5Node = hDF5NodeLink.getDestination();
        HDF5Attribute hDF5Attribute = hDF5Node.getAttribute("NX_class");
        if (hDF5Attribute != null) {
            string = String.valueOf(string) + hDF5Attribute.getFirstElement() + " ";
        }
        if (hDF5Node instanceof HDF5Dataset) {
            int[] nArray;
            HDF5Dataset hDF5Dataset = (HDF5Dataset)hDF5Node;
            string = String.valueOf(string) + "SDS ";
            if (hDF5Dataset.isString()) {
                string = String.valueOf(string) + hDF5Dataset.getTypeName() + " ";
                if ((string = String.valueOf(string) + hDF5Dataset.getString() + " ").length() > 100) {
                    string = String.valueOf(string.substring(0, 100)) + "...";
                }
                return string;
            }
            if (!hDF5Dataset.isSupported()) {
                return String.valueOf(string) + "Not supported";
            }
            ILazyDataset iLazyDataset = hDF5Dataset.getDataset();
            int[] nArray2 = nArray = iLazyDataset.getShape();
            int n = nArray.length;
            int n4 = 0;
            while (n4 < n) {
                int n5 = nArray2[n4];
                string = String.valueOf(string) + n5 + ", ";
                ++n4;
            }
            if (string.length() > 2) {
                string = String.valueOf(string) + string.substring(0, string.length() - 2) + " ";
            }
            string = String.valueOf(string) + hDF5Dataset.getTypeName() + " ";
            string = iLazyDataset instanceof AbstractDataset ? String.valueOf(string) + ((AbstractDataset)iLazyDataset).getString(new int[]{0}) + " " : String.valueOf(string) + "Select to view";
        }
        return string;
    }
}

