/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.hdf5;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Attribute;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Dataset;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5File;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Group;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5Node;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.HDF5TableTree;
import uk.ac.diamond.scisoft.analysis.rcp.hdf5.TreeFilter;

public class HDF5ContentProvider
implements ITreeContentProvider {
    private TreeFilter treeFilter = new TreeFilter(new String[]{"target", "NX_class"});
    public static final String H5_EXT = "h5";
    public static final String HDF5_EXT = "hdf5";
    public static final String NXS_EXT = "nxs";
    private HDF5Loader loader;
    private String fileName;
    private IFile modelFile;
    private HDF5File hdf5Tree;
    private static final Object[] NO_CHILDREN = new Object[0];
    private static final Logger logger = LoggerFactory.getLogger(HDF5ContentProvider.class);

    public Object[] getChildren(Object object) {
        Object[] objectArray = NO_CHILDREN;
        if (object instanceof IFile) {
            this.modelFile = (IFile)object;
            if (H5_EXT.equals(this.modelFile.getFileExtension()) || HDF5_EXT.equals(this.modelFile.getFileExtension()) || NXS_EXT.equals(this.modelFile.getFileExtension())) {
                this.loadHDF5Data(this.modelFile);
                HDF5Group hDF5Group = this.hdf5Tree.getGroup();
                objectArray = new Object[hDF5Group.getNumberOfNodelinks()];
                int n = 0;
                for (HDF5NodeLink hDF5NodeLink : hDF5Group) {
                    objectArray[n] = hDF5NodeLink;
                    ++n;
                }
                return objectArray;
            }
        }
        if (object instanceof HDF5Attribute) {
            return null;
        }
        assert (object instanceof HDF5NodeLink) : "Not an attribute or a link";
        HDF5Node hDF5Node = ((HDF5NodeLink)object).getDestination();
        int n = 0;
        Iterator iterator = hDF5Node.getAttributeNameIterator();
        objectArray = new Object[HDF5TableTree.countChildren((Object)object, (TreeFilter)this.treeFilter)];
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!this.treeFilter.select(string2)) continue;
            Iterator iterator2 = hDF5Node.getAttribute(string2);
            objectArray[n] = iterator2;
            ++n;
        }
        if (hDF5Node instanceof HDF5Group) {
            String string;
            for (String string2 : (HDF5Group)hDF5Node) {
                if (!string2.isDestinationAGroup() || !this.treeFilter.select(string = string2.getName())) continue;
                objectArray[n] = string2;
                ++n;
            }
            for (String string2 : (HDF5Group)hDF5Node) {
                if (!string2.isDestinationADataset() || !this.treeFilter.select(string = string2.getName())) continue;
                objectArray[n] = string2;
                ++n;
            }
        } else {
            boolean cfr_ignored_0 = hDF5Node instanceof HDF5Dataset;
        }
        return objectArray;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public boolean hasChildren(Object object) {
        return object instanceof HDF5NodeLink && HDF5TableTree.countChildren((Object)object, (TreeFilter)this.treeFilter) > 0 || object instanceof IFile;
    }

    public Object getParent(Object object) {
        if (object == null || !(object instanceof HDF5NodeLink)) {
            return null;
        }
        HDF5Node hDF5Node = ((HDF5NodeLink)object).getSource();
        if (hDF5Node == null) {
            return object;
        }
        return hDF5Node;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
    }

    private void loadHDF5Data(IFile iFile) {
        this.fileName = iFile.getLocation().toString();
        try {
            this.loader = new HDF5Loader(this.fileName);
            this.loader.setAsyncLoad(true);
            this.hdf5Tree = this.loader.loadTree(null);
        }
        catch (Exception exception) {
            logger.warn("Could not load NeXus file {}", (Object)this.fileName);
        }
    }
}

