/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.decorator;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.IExtendedMetadata;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class LightweightSRSScanCmdDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "uk.ac.diamond.sda.navigator.srsScancmdDecorator";
    private static final String SRS_EXT = "dat";
    private IExtendedMetadata metaData;
    private String decorator = "";
    private static final Logger logger = LoggerFactory.getLogger(LightweightSRSScanCmdDecorator.class);

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        IFile iFile;
        this.decorator = "";
        if (object instanceof IFile && SRS_EXT.equals((iFile = (IFile)object).getFileExtension())) {
            IFile iFile2 = (IFile)object;
            this.srsMetaDataLoader(iFile2.getLocation().toString());
            try {
                if (this.metaData != null) {
                    this.decorator = this.metaData.getScanCommand();
                    if (this.decorator == null) {
                        this.decorator = " * Scan Command: N/A";
                        iDecoration.addSuffix(this.decorator);
                    } else {
                        if (this.decorator.length() > 100) {
                            this.decorator = String.valueOf(this.decorator.substring(0, 100)) + "...";
                        }
                        this.decorator = " * " + this.decorator;
                        iDecoration.addSuffix(this.decorator);
                    }
                } else {
                    this.decorator = " * Scan Command: N/A";
                    iDecoration.addSuffix(this.decorator);
                    logger.warn("Could not read metadata from file {}", (Object)iFile2.getFullPath());
                }
            }
            catch (Exception exception) {
                logger.error("Could not read metadata from {}: ", (Throwable)exception);
            }
        }
    }

    public IExtendedMetadata srsMyMetaDataLoader(String string) {
        this.srsMetaDataLoader(string);
        return this.metaData;
    }

    private void srsMetaDataLoader(String string) {
        try {
            IMetaData iMetaData = LoaderFactory.getMetaData((String)string, null);
            if (iMetaData instanceof IExtendedMetadata) {
                this.metaData = (IExtendedMetadata)LoaderFactory.getMetaData((String)string, null);
            } else {
                this.decorator = " * Scan Command: N/A";
                logger.warn("Cannot decorate SRS decorator");
            }
        }
        catch (Exception exception) {
            logger.error("Cannot open dat file", (Throwable)exception);
        }
    }
}

