/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.decorator;

import gda.analysis.io.ScanFileHolderException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.ExtendedSRSLoader;
import uk.ac.diamond.scisoft.analysis.rcp.navigator.srs.SRSTreeData;

public class LightweightSRSDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private String decorator;
    private String fileName;
    private static final Logger logger = LoggerFactory.getLogger(LightweightSRSDecorator.class);
    private SRSTreeData srsData;
    private DataHolder data;

    public void decorate(Object object, IDecoration iDecoration) {
        this.decorator = "";
        if (object instanceof SRSTreeData) {
            this.srsData = (SRSTreeData)object;
            IFile iFile = this.srsData.getFile();
            ArrayList<SRSTreeData> arrayList = new ArrayList<SRSTreeData>();
            String[] stringArray = this.data.getNames();
            int n = 0;
            while (n < this.data.size()) {
                ILazyDataset iLazyDataset = this.data.getLazyDataset(n);
                if (iLazyDataset instanceof AbstractDataset) {
                    arrayList.add(new SRSTreeData(stringArray[n], this.data.getDataset(n).min().toString(), this.data.getDataset(n).max().toString(), this.data.getDataset(n).elementClass().toString(), iFile));
                } else {
                    arrayList.add(new SRSTreeData(stringArray[n], "Not available", "Not available", "Not available", iFile));
                }
                ++n;
            }
            arrayList.toArray(new SRSTreeData[arrayList.size()]);
        }
    }

    public void srsFileLoader(IFile iFile) {
        this.fileName = iFile.getLocation().toString();
        try {
            ExtendedSRSLoader extendedSRSLoader = new ExtendedSRSLoader(this.fileName);
            this.data = extendedSRSLoader.loadFile();
        }
        catch (ScanFileHolderException scanFileHolderException) {
            this.data = new DataHolder();
            this.data.addDataset("Failed to load File", (ILazyDataset)new DoubleDataset(new int[]{1}));
            logger.warn("Failed to load srs file");
        }
    }
}

