/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.decorator;

import gda.analysis.io.ScanFileHolderException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.ILazyDataset;
import uk.ac.diamond.scisoft.analysis.dataset.StringDataset;
import uk.ac.diamond.scisoft.analysis.io.HDF5Loader;

public class LightweightNXSScanCmdDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "uk.ac.diamond.sda.navigator.nxsScancmdDecorator";
    private static final String NXS_EXT = "nxs";
    private String decorator = "";
    private static final Logger logger = LoggerFactory.getLogger(LightweightNXSScanCmdDecorator.class);
    private static final String scanCmdName = "scan_command";
    private static final String titleName = "title";

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        IFile iFile;
        this.decorator = "";
        if (object instanceof IFile && NXS_EXT.equals((iFile = (IFile)object).getFileExtension())) {
            IFile iFile2 = (IFile)object;
            try {
                String[][] stringArray = this.getHDF5TitleAndScanCmd(iFile2.getLocation().toString());
                int n = 0;
                while (n < stringArray[0].length) {
                    this.decorator = String.valueOf(stringArray[0][n]) + stringArray[1][n];
                    iDecoration.addSuffix(this.decorator);
                    ++n;
                }
            }
            catch (ScanFileHolderException scanFileHolderException) {
                logger.error("Could not read Nexus file: ", (Throwable)scanFileHolderException);
            }
            catch (Exception exception) {
                logger.error("Could not read Nexus metadata: ", (Throwable)exception);
            }
        }
    }

    public String[][] getMyHDF5TitleAndScanCmd(String string) throws Exception {
        return this.getHDF5TitleAndScanCmd(string);
    }

    private String[][] getHDF5TitleAndScanCmd(String string) throws Exception {
        int n;
        String[][] stringArray;
        List list = new HDF5Loader(string).findDatasets(new String[]{scanCmdName, titleName}, 1, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (ILazyDataset iLazyDataset : list) {
            if (!(iLazyDataset instanceof StringDataset) || (stringArray = iLazyDataset.getName()) == null) continue;
            if (stringArray.contains(scanCmdName)) {
                arrayList.add(iLazyDataset.toString());
                if (arrayList.size() <= arrayList2.size() + 1) continue;
                arrayList2.add(null);
                continue;
            }
            if (!stringArray.contains(titleName)) continue;
            arrayList2.add(iLazyDataset.toString());
            if (arrayList2.size() <= arrayList.size() + 1) continue;
            arrayList.add(null);
        }
        int n2 = arrayList.size();
        if (n2 != (n = arrayList2.size())) {
            while (n2 < n) {
                arrayList.add(null);
                ++n2;
            }
            while (n < n2) {
                arrayList2.add(null);
                ++n;
            }
        }
        stringArray = new String[2][n2];
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)arrayList.get(n3);
            if (string2 != null && string2.length() > 100) {
                string2 = String.valueOf(string2.substring(0, 100)) + "...";
            }
            stringArray[0][n3] = string2 == null ? "" : "\nScanCmd" + (n3 + 1) + ": " + string2;
            string2 = (String)arrayList2.get(n3);
            if (string2 != null && string2.length() > 100) {
                string2 = String.valueOf(string2.substring(0, 100)) + "...";
            }
            stringArray[1][n3] = string2 == null ? "" : "\nTitle" + (n3 + 1) + ": " + string2;
            ++n3;
        }
        return stringArray;
    }
}

