/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.decorator;

import java.io.File;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightweightMetadataDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "uk.ac.diamond.sda.navigator.metadataDecorator";
    private static final Logger logger = LoggerFactory.getLogger(LightweightMetadataDecorator.class);

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IPath iPath = iFile.getLocation();
            File file = iPath.toFile();
            String string = new SimpleDateFormat("dd/MM/yy hh:mm aaa").format(new Date(file.lastModified()));
            String string2 = LightweightMetadataDecorator.getFilePermission(file);
            iDecoration.addSuffix("  " + LightweightMetadataDecorator.readableFileSize(file.length()) + "  " + string);
            if (string2.equals("- - -")) {
                ImageDescriptor imageDescriptor = ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/decorators/unconfigured_co.gif");
                iDecoration.addOverlay(imageDescriptor);
            }
        }
    }

    public static String readableFileSize(long l) {
        if (l <= 0L) {
            return "0";
        }
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB"};
        int n = (int)(Math.log10(l) / Math.log10(1024.0));
        return String.valueOf(new DecimalFormat("#,##0.#").format((double)l / Math.pow(1024.0, n))) + " " + stringArray[n];
    }

    public static String getFilePermission(File file) {
        String string = "-";
        String string2 = "-";
        String string3 = "-";
        if (file.canRead()) {
            string = "r";
        }
        if (file.canWrite()) {
            string2 = "w";
        }
        if (file.canExecute()) {
            string3 = "x";
        }
        return String.valueOf(string) + " " + string2 + " " + string3;
    }
}

