/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.decorator;

import java.io.File;
import java.io.IOException;
import java.util.Scanner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LightweightFileOwnerDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    public static final String ID = "uk.ac.diamond.sda.navigator.fileOwnerDecorator";
    private static final Logger logger = LoggerFactory.getLogger(LightweightFileOwnerDecorator.class);

    public void addListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return false;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
    }

    public void decorate(Object object, IDecoration iDecoration) {
        if (object instanceof IFile) {
            IFile iFile = (IFile)object;
            IPath iPath = iFile.getLocation();
            File file = iPath.toFile();
            iDecoration.addSuffix("  " + LightweightFileOwnerDecorator.getFileOwner(file));
        }
    }

    public static String getFileOwner(File file) {
        String string = "";
        String string2 = System.getProperty("os.name").toLowerCase();
        String string3 = "";
        if (string2.indexOf("nix") >= 0 || string2.indexOf("nux") >= 0 || string2.indexOf("mac") >= 0) {
            string3 = "ls -l " + file.getAbsolutePath();
            try {
                Process process = Runtime.getRuntime().exec(string3);
                Scanner scanner = new Scanner(process.getInputStream());
                if (scanner.hasNext()) {
                    String[] stringArray = scanner.nextLine().split(" ");
                    string = stringArray[2];
                }
            }
            catch (IOException iOException) {
                logger.warn("WARNING: could not get file owner:", (Object)iOException.getMessage());
            }
        }
        return string;
    }
}

