/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import uk.ac.diamond.scisoft.analysis.rcp.navigator.srs.SRSTreeData;
import uk.ac.diamond.sda.intro.navigator.NavigatorRCPActivator;
import uk.ac.gda.common.rcp.util.EclipseUtils;

public class OpenSRSAction
extends Action {
    private IWorkbenchPage page;
    private SRSTreeData data;
    private ISelectionProvider provider;

    public OpenSRSAction(IWorkbenchPage iWorkbenchPage, ISelectionProvider iSelectionProvider) {
        this.setText("Open SRS Editor");
        this.page = iWorkbenchPage;
        this.provider = iSelectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.provider.getSelection();
        if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof SRSTreeData) {
            this.data = (SRSTreeData)iStructuredSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        try {
            if (this.isEnabled()) {
                IFile iFile = this.data.getFile();
                IDE.openEditor((IWorkbenchPage)this.page, (IFile)iFile);
                EclipseUtils.activateView((String)"org.eclipse.ui.navigator.ProjectExplorer");
            }
        }
        catch (PartInitException partInitException) {
            NavigatorRCPActivator.logError(0, "Could not open SRS Editor!", partInitException);
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Opening SRS Editor", (String)"Could not open SRS Editor!");
        }
    }
}

