/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.sda.navigator.actions;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import uk.ac.diamond.scisoft.analysis.hdf5.HDF5NodeLink;
import uk.ac.diamond.sda.intro.navigator.NavigatorRCPActivator;

public class OpenHDF5Action
extends Action {
    private IWorkbenchPage page;
    private HDF5NodeLink link;
    private ISelectionProvider provider;

    public OpenHDF5Action(IWorkbenchPage iWorkbenchPage, ISelectionProvider iSelectionProvider) {
        this.setText("Open HDF5 Editor");
        this.page = iWorkbenchPage;
        this.provider = iSelectionProvider;
    }

    public boolean isEnabled() {
        IStructuredSelection iStructuredSelection;
        ISelection iSelection = this.provider.getSelection();
        if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1 && iStructuredSelection.getFirstElement() instanceof HDF5NodeLink) {
            this.link = (HDF5NodeLink)iStructuredSelection.getFirstElement();
            return true;
        }
        return false;
    }

    public void run() {
        String string = this.link.getFile().getFilename();
        IFileStore iFileStore = EFS.getLocalFileSystem().getStore((IPath)new Path("/"));
        if (!(iFileStore = iFileStore.getFileStore((IPath)new Path(string))).fetchInfo().isDirectory() && iFileStore.fetchInfo().exists()) {
            try {
                if (this.isEnabled()) {
                    IDE.openEditorOnFileStore((IWorkbenchPage)this.page, (IFileStore)iFileStore);
                }
            }
            catch (PartInitException partInitException) {
                NavigatorRCPActivator.logError(0, "Could not open HDF5 Editor!", partInitException);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error Opening HDF5 Editor", (String)"Could not open HDF5 Editor!");
            }
        }
    }
}

