/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.views.cheatsheets;

import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.common.ui.views.ImageMonitorView;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorDirectoryItem
extends AbstractItemExtensionElement {
    private static Logger logger = LoggerFactory.getLogger(MonitorDirectoryItem.class);
    private String path;

    public MonitorDirectoryItem(String string) {
        super(string);
    }

    public void handleAttribute(String string) {
        this.path = string;
    }

    public void createControl(Composite composite) {
        Button button = new Button(composite, 0);
        button.setText("Monitor");
        button.setToolTipText("Click to set the monitor directory to " + this.getPath());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    ImageMonitorView imageMonitorView = (ImageMonitorView)EclipseUtils.getActivePage().showView("org.dawb.workbench.views.imageMonitorView");
                    imageMonitorView.setDirectoryPath(MonitorDirectoryItem.this.getPath());
                }
                catch (PartInitException partInitException) {
                    logger.error("Cannot find Image Monitor Part", (Throwable)partInitException);
                }
            }
        });
    }

    private String getPath() {
        String string = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        return String.valueOf(string) + "/" + this.path;
    }

    public void dispose() {
    }
}

