/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dawb.common.ui.menu.CheckableActionGroup;
import org.dawb.common.ui.plot.AbstractPlottingSystem;
import org.dawb.common.ui.plot.IPlottingSystem;
import org.dawb.common.ui.plot.PlotType;
import org.dawb.common.ui.slicing.SliceComponent;
import org.dawb.common.ui.util.EclipseUtils;
import org.dawb.workbench.ui.Activator;
import org.dawb.workbench.ui.editors.CheckableObject;
import org.dawb.workbench.ui.editors.IDatasetEditor;
import org.dawb.workbench.ui.editors.IPlotUpdateParticipant;
import org.dawb.workbench.ui.editors.PlotDataComponent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;

public class PlotDataPage
extends Page
implements IPlotUpdateParticipant,
IAdaptable {
    private static final Logger logger = LoggerFactory.getLogger(PlotDataPage.class);
    private IDatasetEditor editor;
    private PlotDataComponent dataSetComponent;
    private IResourceChangeListener resourceListener;
    private SliceComponent sliceComponent;
    private Composite content;

    public PlotDataPage(IDatasetEditor iDatasetEditor) {
        this.editor = iDatasetEditor;
    }

    public void createControl(Composite composite) {
        this.content = new Composite(composite, 0);
        this.content.setLayout((Layout)new GridLayout(1, true));
        SashForm sashForm = new SashForm(this.content, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.dataSetComponent = new PlotDataComponent(this.editor);
        this.dataSetComponent.createPartControl((Composite)sashForm);
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        arrayList.addAll(this.createPlotActions());
        arrayList.addAll(this.dataSetComponent.getDimensionalActions());
        for (IAction iAction2 : arrayList) {
            this.getSite().getActionBars().getToolBarManager().add(iAction2);
            if (iAction2.getText() == null || !iAction2.getText().toLowerCase().contains("preference")) continue;
            this.getSite().getActionBars().getMenuManager().add(iAction2);
        }
        this.getSite().setSelectionProvider(this.dataSetComponent.getViewer());
        this.dataSetComponent.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                List list = ((StructuredSelection)selectionChangedEvent.getSelection()).toList();
                if (list != null) {
                    PlotDataPage.this.editor.updatePlot(list.toArray(new CheckableObject[list.size()]), PlotDataPage.this, true);
                }
            }
        });
        this.dataSetComponent.setFileName(this.editor.getEditorInput().getName());
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        this.resourceListener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                if (iResourceChangeEvent == null || iResourceChangeEvent.getDelta() == null) {
                    return;
                }
                final IFile iFile = EclipseUtils.getIFile((IEditorInput)PlotDataPage.this.editor.getEditorInput());
                if (iFile == null) {
                    return;
                }
                if (iResourceChangeEvent.getDelta().findMember(iFile.getFullPath()) != null) {
                    PlotDataPage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                iFile.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (CoreException coreException) {
                                logger.error("Cannot refresh " + iFile, (Throwable)coreException);
                            }
                            PlotDataPage.this.editor.setInput((IEditorInput)new FileEditorInput(iFile));
                            List<CheckableObject> list = PlotDataPage.this.dataSetComponent.getSelections();
                            if (list != null) {
                                PlotDataPage.this.editor.updatePlot(list.toArray(new CheckableObject[list.size()]), PlotDataPage.this, false);
                            }
                        }
                    });
                }
            }
        };
        iWorkspace.addResourceChangeListener(this.resourceListener);
        this.sliceComponent = new SliceComponent("org.dawb.workbench.views.h5GalleryView");
        this.sliceComponent.createPartControl((Composite)sashForm);
        this.sliceComponent.setVisible(false);
        sashForm.setWeights(new int[]{40, 60});
    }

    private Collection<? extends IAction> createPlotActions() {
        ArrayList<Action> arrayList = new ArrayList<Action>(3);
        CheckableActionGroup checkableActionGroup = new CheckableActionGroup();
        Action action = new Action("Plot 2D data as images", 2){

            public void run() {
                PlotDataPage.this.sliceComponent.setImagePlotType(PlotType.IMAGE);
                PlotDataPage.this.sliceComponent.slice(true);
            }
        };
        action.setImageDescriptor(Activator.getImageDescriptor("icons/image_editor.png"));
        action.setChecked(true);
        arrayList.add(action);
        checkableActionGroup.add((IAction)action);
        Action action2 = new Action("Plot 2D data as multiple 1D plots", 2){

            public void run() {
                PlotDataPage.this.sliceComponent.setImagePlotType(PlotType.PT1D_MULTI);
                PlotDataPage.this.sliceComponent.slice(true);
            }
        };
        action2.setImageDescriptor(Activator.getImageDescriptor("icons/ascii_editor.png"));
        action2.setChecked(false);
        arrayList.add(action2);
        checkableActionGroup.add((IAction)action2);
        return arrayList;
    }

    public Control getControl() {
        return this.content;
    }

    public void setFocus() {
        this.dataSetComponent.setFocus();
    }

    public void dispose() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace != null && this.resourceListener != null) {
            iWorkspace.removeResourceChangeListener(this.resourceListener);
        }
        if (this.dataSetComponent != null) {
            this.dataSetComponent.dispose();
        }
        if (this.sliceComponent != null) {
            this.sliceComponent.dispose();
        }
        super.dispose();
    }

    public PlotDataComponent getDataSetComponent() {
        return this.dataSetComponent;
    }

    @Override
    public void setSlicerVisible(boolean bl) {
        this.sliceComponent.setVisible(bl);
    }

    @Override
    public int getDimensionCount(CheckableObject checkableObject) {
        return this.dataSetComponent.getDimensionCount(checkableObject);
    }

    @Override
    public IMetaData getMetaData() {
        return this.dataSetComponent.getMetaData();
    }

    @Override
    public void setSlicerData(String string, String string2, int[] nArray, AbstractPlottingSystem abstractPlottingSystem) {
        this.sliceComponent.setData(string, string2, nArray, (IPlottingSystem)abstractPlottingSystem);
    }

    @Override
    public PlotType getPlotMode() {
        return this.dataSetComponent.getPlotMode();
    }

    public SliceComponent getSliceComponent() {
        return this.sliceComponent;
    }

    public Object getAdapter(Class clazz) {
        if (clazz == String.class) {
            return "Data";
        }
        return null;
    }
}

