/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.project;

import java.io.File;
import org.dawb.common.util.eclipse.BundleUtils;
import org.dawb.common.util.io.FileUtils;
import org.dawb.workbench.ui.project.DataNature;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProjectUtils {
    private static Logger logger = LoggerFactory.getLogger(DataProjectUtils.class);

    public static IProject createDataProject(String string, IWorkspaceRoot iWorkspaceRoot, boolean bl, IProgressMonitor iProgressMonitor) throws Exception {
        if (iWorkspaceRoot.getProject(string).exists()) {
            return iWorkspaceRoot.getProject(string);
        }
        IProject iProject = iWorkspaceRoot.getProject(string);
        iProject.create(iProgressMonitor);
        iProject.open(iProgressMonitor);
        if (bl) {
            IFolder iFolder = iProject.getFolder("examples");
            iFolder.create(true, true, iProgressMonitor);
            File file = BundleUtils.getBundleLocation((String)"org.dawb.workbench.examples");
            File file2 = new File(file, "data");
            logger.debug("Using data folder " + file2.getAbsolutePath());
            if (file2.exists()) {
                FileUtils.recursiveCopy((File)file2, (File)new File(iFolder.getLocation().toOSString()));
            }
        }
        DataProjectUtils.addDataNature(iProject, iProgressMonitor);
        iProject.refreshLocal(2, iProgressMonitor);
        return iProject;
    }

    private static void addDataNature(IProject iProject, IProgressMonitor iProgressMonitor) throws CoreException {
        IProjectDescription iProjectDescription = iProject.getDescription();
        iProjectDescription.setNatureIds(new String[]{DataNature.ID});
        iProject.setDescription(iProjectDescription, iProgressMonitor);
    }
}

