/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.project;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DataNewProjectWizardPage
extends WizardPage {
    private Text projectName;
    private Button examples;
    private ISelection selection;

    public DataNewProjectWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.setTitle("Create new data project");
        this.setDescription("A project marked as a data project.");
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 2;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText("&Project name:");
        this.projectName = new Text(composite2, 2052);
        this.projectName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.projectName.setLayoutData((Object)new GridData(768));
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                DataNewProjectWizardPage.this.dialogChanged();
            }
        });
        Label label2 = new Label(composite2, 0);
        label2.setText("&Create example data");
        this.examples = new Button(composite2, 32);
        this.examples.setSelection(false);
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void dialogChanged() {
        String string = this.getProjectName();
        if (string == null || "".equals(string)) {
            this.updateStatus("Please set the project name");
            return;
        }
        IProject iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
        if (iProject != null && iProject.exists()) {
            this.updateStatus("Please set a unique name, '" + string + "' already exists");
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getProjectName() {
        if (this.projectName == null || this.projectName.isDisposed()) {
            return null;
        }
        return this.projectName.getText();
    }

    public boolean isExamples() {
        if (this.examples == null || this.examples.isDisposed()) {
            return false;
        }
        return this.examples.getSelection();
    }
}

