/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors.slicing;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.dawb.common.util.io.FileUtils;

public class ZipUtils {
    private static final Map<String, Class<? extends InputStream>> CLASSES = new HashMap<String, Class<? extends InputStream>>(3);

    static {
        CLASSES.put("gz", GZIPInputStream.class);
        CLASSES.put("zip", ZipInputStream.class);
        CLASSES.put("bz2", CBZip2InputStream.class);
    }

    public static InputStream getStreamForFile(String string) throws Exception {
        File file = new File(string);
        return ZipUtils.getStreamForFile(file);
    }

    public static InputStream getStreamForFile(File file) throws Exception {
        String string = FileUtils.getFileExtension((File)file);
        Class<? extends InputStream> clazz = CLASSES.get(string);
        Constructor<? extends InputStream> constructor = clazz.getConstructor(InputStream.class);
        InputStream inputStream = constructor.newInstance(new FileInputStream(file));
        if (inputStream instanceof ZipInputStream) {
            ((ZipInputStream)inputStream).getNextEntry();
        }
        return inputStream;
    }
}

