/*
 * Decompiled with CFR 0.152.
 */
package org.dawb.workbench.ui.editors.slicing;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dawb.common.ui.monitor.ProgressMonitorWrapper;
import org.dawb.common.ui.plot.IPlottingSystemData;
import org.eclipse.core.runtime.IProgressMonitor;
import org.nfunk.jep.JEP;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.SymbolTable;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.gda.monitor.IMonitor;

public class ExpressionObject {
    private String expression;
    private String mementoKey;
    private IPlottingSystemData provider;
    private JEP jepParser;
    private AbstractDataset dataSet;

    public ExpressionObject(IPlottingSystemData iPlottingSystemData) {
        this(iPlottingSystemData, null, ExpressionObject.generateMementoKey());
    }

    public ExpressionObject(IPlottingSystemData iPlottingSystemData, String string, String string2) {
        this.provider = iPlottingSystemData;
        this.expression = string;
        this.mementoKey = string2;
    }

    public static boolean isExpressionKey(String string) {
        if (string == null) {
            return false;
        }
        if ("".equals(string)) {
            return false;
        }
        return string.matches("Expression\\:(\\d)+");
    }

    private static String generateMementoKey() {
        return "Expression:" + new Date().getTime();
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        this.dataSet = null;
        this.expression = string;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.expression == null ? 0 : this.expression.hashCode());
        n = 31 * n + (this.mementoKey == null ? 0 : this.mementoKey.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ExpressionObject expressionObject = (ExpressionObject)object;
        if (this.expression == null ? expressionObject.expression != null : !this.expression.equals(expressionObject.expression)) {
            return false;
        }
        return !(this.mementoKey == null ? expressionObject.mementoKey != null : !this.mementoKey.equals(expressionObject.mementoKey));
    }

    public String toString() {
        return this.expression != null ? this.expression : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid(IProgressMonitor iProgressMonitor) {
        try {
            SymbolTable symbolTable = this.getSymbolTable();
            Iterator iterator = symbolTable.keySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object e = iterator.next();
                Object object = symbolTable.getValue(e);
                if (object != null) continue;
                if (iProgressMonitor.isCanceled()) {
                    return false;
                }
                if (!this.provider.isExpressionSetName(e.toString(), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor))) break;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int getSize(IProgressMonitor iProgressMonitor) {
        if (this.dataSet == null) {
            try {
                this.getDataSet(iProgressMonitor);
            }
            catch (Exception exception) {
                return 0;
            }
        }
        return this.dataSet != null ? this.dataSet.getSize() : 0;
    }

    public AbstractDataset getDataSet(IProgressMonitor iProgressMonitor) throws Exception {
        if (this.dataSet != null) {
            return this.dataSet;
        }
        if (this.expression == null || this.provider == null) {
            return new DoubleDataset();
        }
        List<AbstractDataset> list = this.getVariables(iProgressMonitor);
        double[] dArray = new double[list.get(0).getSize()];
        int n = 0;
        while (n < dArray.length) {
            for (AbstractDataset abstractDataset : list) {
                String string = ExpressionObject.getSafeName(abstractDataset.getName());
                this.jepParser.addVariable(string, abstractDataset.getDouble(new int[]{n}));
            }
            this.jepParser.parseExpression(this.expression);
            dArray[n] = this.jepParser.getValue();
            ++n;
        }
        this.dataSet = new DoubleDataset(dArray, new int[0]);
        this.dataSet.setName(this.getExpression());
        return this.dataSet;
    }

    private List<AbstractDataset> getVariables(IProgressMonitor iProgressMonitor) throws Exception {
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>(7);
        SymbolTable symbolTable = this.getSymbolTable();
        for (Object e : symbolTable.keySet()) {
            AbstractDataset abstractDataset;
            Iterator iterator = symbolTable.getValue(e);
            if (iterator != null) continue;
            if (iProgressMonitor.isCanceled()) {
                return null;
            }
            AbstractDataset abstractDataset2 = abstractDataset = this.provider != null ? this.provider.getExpressionSet(e.toString(), (IMonitor)new ProgressMonitorWrapper(iProgressMonitor)) : null;
            if (abstractDataset == null) continue;
            arrayList.add(abstractDataset);
        }
        if (arrayList.isEmpty()) {
            throw new Exception("No variables recognized in expression.");
        }
        int n = ((AbstractDataset)arrayList.get(0)).getSize();
        for (IDataset iDataset : arrayList) {
            if (iDataset.getSize() == n) continue;
            throw new Exception("Data sets in expression are not all the same size.");
        }
        return arrayList;
    }

    private SymbolTable getSymbolTable() throws ParseException {
        this.jepParser = new JEP();
        this.jepParser.addStandardFunctions();
        this.jepParser.addStandardConstants();
        this.jepParser.setAllowUndeclared(true);
        this.jepParser.setImplicitMul(true);
        this.jepParser.parse(this.expression);
        return this.jepParser.getSymbolTable();
    }

    public IPlottingSystemData getProvider() {
        return this.provider;
    }

    public void setProvider(IPlottingSystemData iPlottingSystemData) {
        this.provider = iPlottingSystemData;
    }

    public String getMementoKey() {
        return this.mementoKey;
    }

    public void setMementoKey(String string) {
        this.mementoKey = string;
    }

    public void clear() {
        this.dataSet = null;
    }

    public static String getSafeName(String string) {
        if (string == null) {
            return null;
        }
        if (string.matches("[a-zA-Z0-9_]+")) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (String.valueOf(c).matches("[a-zA-Z0-9_]")) {
                stringBuilder.append(c);
            } else if (stringBuilder.length() >= 1 && !"_".equals(stringBuilder.substring(stringBuilder.length() - 1))) {
                stringBuilder.append("_");
            }
            ++n2;
        }
        if (stringBuilder.length() < 1) {
            stringBuilder.append("Invalid_name");
        } else if (stringBuilder.substring(0, 1).matches("[0-9]")) {
            stringBuilder.append("var", 0, 3);
        }
        return stringBuilder.toString();
    }
}

